/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsPath
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(AsPath.class);
    public static final byte ASPATH_TYPE = 2;
    public static final byte ASPATH_SET_TYPE = 1;
    public static final byte ASPATH_SEQ_TYPE = 2;
    public static final byte ASNUM_SIZE = 2;
    private boolean isAsPath = false;
    private List<Short> aspathSet;
    private List<Short> aspathSeq;

    public AsPath() {
        this.aspathSeq = null;
        this.aspathSet = null;
    }

    public AsPath(List<Short> aspathSet, List<Short> aspathSeq) {
        this.aspathSeq = aspathSeq;
        this.aspathSet = aspathSet;
        this.isAsPath = true;
    }

    public static AsPath read(ChannelBuffer cb) throws BgpParseException {
        ArrayList<Short> aspathSet = new ArrayList<Short>();
        ArrayList<Short> aspathSeq = new ArrayList<Short>();
        ChannelBuffer tempCb = cb.copy();
        Validation validation = Validation.parseAttributeHeader(cb);
        if (cb.readableBytes() < validation.getLength()) {
            Validation.validateLen((byte)3, (byte)5, validation.getLength());
        }
        int len = validation.isShort() ? validation.getLength() + 4 : validation.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (validation.getFirstBit() && !validation.getSecondBit() && validation.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        ChannelBuffer tempBuf = cb.readBytes(validation.getLength());
        while (tempBuf.readableBytes() > 0) {
            byte pathSegType = tempBuf.readByte();
            byte pathSegLen = tempBuf.readByte();
            int length = pathSegLen * 2;
            if (tempBuf.readableBytes() < length) {
                Validation.validateLen((byte)3, (byte)5, length);
            }
            ChannelBuffer aspathBuf = tempBuf.readBytes(length);
            block5: while (aspathBuf.readableBytes() > 0) {
                short asNum = aspathBuf.readShort();
                switch (pathSegType) {
                    case 1: {
                        aspathSet.add(asNum);
                        continue block5;
                    }
                    case 2: {
                        aspathSeq.add(asNum);
                        continue block5;
                    }
                }
                log.debug("Other type Not Supported:" + pathSegType);
            }
        }
        return new AsPath(aspathSet, aspathSeq);
    }

    @Override
    public short getType() {
        return 2;
    }

    public boolean isaspathSet() {
        return this.isAsPath;
    }

    public List<Short> asPathSeq() {
        return this.aspathSeq;
    }

    public List<Short> asPathSet() {
        return this.aspathSet;
    }

    public int hashCode() {
        return Objects.hash(this.aspathSet, this.aspathSeq);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AsPath) {
            AsPath other = (AsPath)obj;
            return Objects.equals(this.aspathSet, other.aspathSet) && Objects.equals(this.aspathSeq, other.aspathSeq);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("aspathSet", this.aspathSet).add("aspathSeq", this.aspathSeq).toString();
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    public static enum ASTYPE {
        AS_SET(1),
        AS_SEQUENCE(2),
        AS_CONFED_SEQUENCE(3),
        AS_CONFED_SET(4);

        int value;

        private ASTYPE(int val) {
            this.value = val;
        }

        public byte type() {
            return (byte)this.value;
        }
    }
}

