/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class LocalPref
implements BgpValueType {
    public static final byte LOCAL_PREF_TYPE = 5;
    public static final byte LOCAL_PREF_MAX_LEN = 4;
    private int localPref;

    public LocalPref(int localPref) {
        this.localPref = localPref;
    }

    public int localPref() {
        return this.localPref;
    }

    public static LocalPref read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempCb = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        if (parseFlags.getLength() > 4 || cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (parseFlags.getFirstBit()) {
            throw new BgpParseException(3, 4, data);
        }
        int localPref = cb.readInt();
        return new LocalPref(localPref);
    }

    @Override
    public short getType() {
        return 5;
    }

    public int hashCode() {
        return Objects.hash(this.localPref);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalPref) {
            LocalPref other = (LocalPref)obj;
            return Objects.equals(this.localPref, other.localPref);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localPref", this.localPref).toString();
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

