/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpReachNlri
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(MpReachNlri.class);
    public static final byte MPREACHNLRI_TYPE = 14;
    public static final byte LINK_NLRITYPE = 2;
    private boolean isMpReachNlri = false;
    private final List<BgpLSNlri> mpReachNlri;
    private final int length;
    private final short afi;
    private final byte safi;
    private final Ip4Address ipNextHop;

    public MpReachNlri(List<BgpLSNlri> mpReachNlri, short afi, byte safi, Ip4Address ipNextHop, int length) {
        this.mpReachNlri = mpReachNlri;
        this.isMpReachNlri = true;
        this.ipNextHop = ipNextHop;
        this.afi = afi;
        this.safi = safi;
        this.length = length;
    }

    public boolean isMpReachNlriSet() {
        return this.isMpReachNlri;
    }

    public List<BgpLSNlri> mpReachNlri() {
        return this.mpReachNlri;
    }

    public int mpReachNlriLen() {
        return this.length;
    }

    public static MpReachNlri read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempBuf = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempBuf.readBytes(len);
        if (cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        if (!parseFlags.getFirstBit() && parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        BgpLSNlri bgpLSNlri = null;
        LinkedList<BgpLSNlri> mpReachNlri = new LinkedList<BgpLSNlri>();
        ChannelBuffer tempCb = cb.readBytes(parseFlags.getLength());
        short afi = 0;
        byte safi = 0;
        Ip4Address ipNextHop = null;
        while (tempCb.readableBytes() > 0) {
            afi = tempCb.readShort();
            safi = tempCb.readByte();
            if (afi == 16388 && safi == 71 || afi == 16388 && safi == -128) {
                byte nextHopLen = tempCb.readByte();
                InetAddress ipAddress = Validation.toInetAddress(nextHopLen, tempCb);
                if (ipAddress.isMulticastAddress()) {
                    throw new BgpParseException("Multicast not supported");
                }
                ipNextHop = Ip4Address.valueOf((InetAddress)ipAddress);
                byte reserved = tempCb.readByte();
                while (tempCb.readableBytes() > 0) {
                    short nlriType = tempCb.readShort();
                    short totNlriLen = tempCb.readShort();
                    if (tempCb.readableBytes() < totNlriLen) {
                        Validation.validateLen((byte)3, (byte)5, totNlriLen);
                    }
                    tempBuf = tempCb.readBytes((int)totNlriLen);
                    switch (nlriType) {
                        case 1: {
                            bgpLSNlri = BgpNodeLSNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        case 2: {
                            bgpLSNlri = BgpLinkLsNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        case 3: {
                            bgpLSNlri = BgpPrefixIPv4LSNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        default: {
                            log.debug("nlriType not supported" + nlriType);
                        }
                    }
                    mpReachNlri.add(bgpLSNlri);
                }
                continue;
            }
            throw new BgpParseException("Not Supporting afi " + afi + "safi " + safi);
        }
        return new MpReachNlri(mpReachNlri, afi, safi, ipNextHop, parseFlags.getLength());
    }

    @Override
    public short getType() {
        return 14;
    }

    public short afi() {
        return this.afi;
    }

    public Ip4Address nexthop4() {
        return this.ipNextHop;
    }

    public byte safi() {
        return this.safi;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("mpReachNlri", this.mpReachNlri).add("afi", (int)this.afi).add("safi", (int)this.safi).add("ipNextHop", (Object)this.ipNextHop).add("length", this.length).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

