/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpUnReachNlri
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(MpUnReachNlri.class);
    public static final byte MPUNREACHNLRI_TYPE = 15;
    public static final byte LINK_NLRITYPE = 2;
    private boolean isMpUnReachNlri = false;
    private final short afi;
    private final byte safi;
    private final List<BgpLSNlri> mpUnReachNlri;
    private final int length;

    public MpUnReachNlri(List<BgpLSNlri> mpUnReachNlri, short afi, byte safi, int length) {
        this.mpUnReachNlri = mpUnReachNlri;
        this.isMpUnReachNlri = true;
        this.afi = afi;
        this.safi = safi;
        this.length = length;
    }

    public static MpUnReachNlri read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempBuf = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempBuf.readBytes(len);
        if (!parseFlags.getFirstBit() && parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        if (cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        LinkedList<BgpLSNlri> mpUnReachNlri = new LinkedList<BgpLSNlri>();
        BgpLSNlri bgpLSNlri = null;
        short afi = 0;
        byte safi = 0;
        ChannelBuffer tempCb = cb.readBytes(parseFlags.getLength());
        while (tempCb.readableBytes() > 0) {
            afi = tempCb.readShort();
            safi = tempCb.readByte();
            if (afi == 16388 && safi == 71 || afi == 16388 && safi == -128) {
                while (tempCb.readableBytes() > 0) {
                    short nlriType = tempCb.readShort();
                    short totNlriLen = tempCb.readShort();
                    if (tempCb.readableBytes() < totNlriLen) {
                        Validation.validateLen((byte)3, (byte)5, totNlriLen);
                    }
                    tempBuf = tempCb.readBytes((int)totNlriLen);
                    switch (nlriType) {
                        case 1: {
                            bgpLSNlri = BgpNodeLSNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        case 2: {
                            bgpLSNlri = BgpLinkLsNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        case 3: {
                            bgpLSNlri = BgpPrefixIPv4LSNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        default: {
                            log.debug("nlriType not supported" + nlriType);
                        }
                    }
                    mpUnReachNlri.add(bgpLSNlri);
                }
                continue;
            }
            throw new BgpParseException("Not Supporting afi " + afi + "safi " + safi);
        }
        return new MpUnReachNlri(mpUnReachNlri, afi, safi, parseFlags.getLength());
    }

    @Override
    public short getType() {
        return 15;
    }

    public byte safi() {
        return this.safi;
    }

    public short afi() {
        return this.afi;
    }

    public List<BgpLSNlri> mpUnReachNlri() {
        return this.mpUnReachNlri;
    }

    public boolean isMpUnReachNlriSet() {
        return this.isMpUnReachNlri;
    }

    public int mpUnReachNlriLen() {
        return this.length;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("mpReachNlri", this.mpUnReachNlri).add("afi", (int)this.afi).add("safi", (int)this.safi).add("length", this.length).toString();
    }
}

