/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.protocol.IGPRouterID;
import org.onosproject.bgpio.types.BgpValueType;

public class OSPFNonPseudonode
implements IGPRouterID,
BgpValueType {
    public static final short TYPE = 515;
    public static final short LENGTH = 4;
    private final int routerID;

    public OSPFNonPseudonode(int routerID) {
        this.routerID = routerID;
    }

    public static OSPFNonPseudonode of(int routerID) {
        return new OSPFNonPseudonode(routerID);
    }

    public int getrouterID() {
        return this.routerID;
    }

    public int hashCode() {
        return Objects.hash(this.routerID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OSPFNonPseudonode) {
            OSPFNonPseudonode other = (OSPFNonPseudonode)obj;
            return Objects.equals(this.routerID, other.routerID);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(515);
        c.writeShort(4);
        c.writeInt(this.routerID);
        return c.writerIndex() - iLenStartIndex;
    }

    public static OSPFNonPseudonode read(ChannelBuffer cb) {
        return OSPFNonPseudonode.of(cb.readInt());
    }

    @Override
    public short getType() {
        return 515;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return Integer.valueOf(this.routerID).compareTo(((OSPFNonPseudonode)o).routerID);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 515).add("Length", 4).add("RouterID", this.routerID).toString();
    }
}

