/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;

public class OSPFRouteTypeTlv
implements BgpValueType {
    public static final short TYPE = 264;
    public static final short LENGTH = 1;
    public static final int INTRA_AREA_TYPE = 1;
    public static final short INTER_AREA_TYPE = 2;
    public static final short EXTERNAL_TYPE_1 = 3;
    public static final short EXTERNAL_TYPE_2 = 4;
    public static final short NSSA_TYPE_1 = 5;
    public static final short NSSA_TYPE_2 = 6;
    private final byte routeType;

    public OSPFRouteTypeTlv(byte routeType) {
        this.routeType = routeType;
    }

    public static OSPFRouteTypeTlv of(byte routeType) {
        return new OSPFRouteTypeTlv(routeType);
    }

    public RouteType getValue() throws BgpParseException {
        switch (this.routeType) {
            case 1: {
                return RouteType.Intra_Area;
            }
            case 2: {
                return RouteType.Inter_Area;
            }
            case 3: {
                return RouteType.External_1;
            }
            case 4: {
                return RouteType.External_2;
            }
            case 5: {
                return RouteType.NSSA_1;
            }
            case 6: {
                return RouteType.NSSA_2;
            }
        }
        throw new BgpParseException(3, 0, null);
    }

    public int hashCode() {
        return Objects.hash(this.routeType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OSPFRouteTypeTlv) {
            OSPFRouteTypeTlv other = (OSPFRouteTypeTlv)obj;
            return Objects.equals(this.routeType, other.routeType);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(264);
        c.writeShort(1);
        c.writeByte((int)this.routeType);
        return c.writerIndex() - iLenStartIndex;
    }

    public static OSPFRouteTypeTlv read(ChannelBuffer cb) {
        return OSPFRouteTypeTlv.of(cb.readByte());
    }

    @Override
    public short getType() {
        return 264;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return Byte.valueOf(this.routeType).compareTo(((OSPFRouteTypeTlv)o).routeType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 264).add("Length", 1).add("Value", (int)this.routeType).toString();
    }

    public static enum RouteType {
        Intra_Area(1),
        Inter_Area(2),
        External_1(3),
        External_2(4),
        NSSA_1(5),
        NSSA_2(6);

        int value;

        private RouteType(int val) {
            this.value = val;
        }

        public byte getType() {
            return (byte)this.value;
        }
    }
}

