/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkAttrIgpMetric
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpLinkAttrIgpMetric.class);
    public static final int ATTRLINK_IGPMETRIC = 1095;
    public static final int ATTRLINK_MAX_LEN = 3;
    public static final int ISIS_SMALL_METRIC = 1;
    public static final int OSPF_LINK_METRIC = 2;
    public static final int ISIS_WIDE_METRIC = 3;
    private final int igpMetric;
    private final int igpMetricLen;

    public BgpLinkAttrIgpMetric(int igpMetric, int igpMetricLen) {
        this.igpMetric = igpMetric;
        this.igpMetricLen = igpMetricLen;
    }

    public static BgpLinkAttrIgpMetric of(int igpMetric, int igpMetricLen) {
        return new BgpLinkAttrIgpMetric(igpMetric, igpMetricLen);
    }

    public static BgpLinkAttrIgpMetric read(ChannelBuffer cb) throws BgpParseException {
        int igpMetric = 0;
        int igpMetricLen = 0;
        short lsAttrLength = cb.readShort();
        if (cb.readableBytes() < lsAttrLength || lsAttrLength > 3) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        switch (lsAttrLength) {
            case 1: {
                igpMetric = cb.readByte();
                igpMetricLen = 1;
                break;
            }
            case 2: {
                igpMetric = cb.readShort();
                igpMetricLen = 2;
                break;
            }
            case 3: {
                short linkigp = cb.readShort();
                igpMetric = cb.readByte();
                igpMetric = igpMetric << 16 | linkigp;
                igpMetricLen = 3;
                break;
            }
        }
        return BgpLinkAttrIgpMetric.of(igpMetric, igpMetricLen);
    }

    public int attrLinkIgpMetric() {
        return this.igpMetric;
    }

    public int attrLinkIgpMetricLength() {
        return this.igpMetricLen;
    }

    @Override
    public short getType() {
        return 1095;
    }

    public int hashCode() {
        return Objects.hash(this.igpMetric, this.igpMetricLen);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrIgpMetric) {
            BgpLinkAttrIgpMetric other = (BgpLinkAttrIgpMetric)obj;
            return Objects.equals(this.igpMetric, other.igpMetric) && Objects.equals(this.igpMetricLen, other.igpMetricLen);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("igpMetric", this.igpMetric).add("igpMetricLen", this.igpMetricLen).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

