/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpLinkAttrIsIsAdminstGrp
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpLinkAttrIsIsAdminstGrp.class);
    public static final int ATTRLINK_PROTECTIONTYPE = 1088;
    public static final int ISIS_ADMIN_DATA_LEN = 4;
    private final long isisAdminGrp;

    public BgpLinkAttrIsIsAdminstGrp(long isisAdminGrp) {
        this.isisAdminGrp = isisAdminGrp;
    }

    public static BgpLinkAttrIsIsAdminstGrp of(long isisAdminGrp) {
        return new BgpLinkAttrIsIsAdminstGrp(isisAdminGrp);
    }

    public static BgpLinkAttrIsIsAdminstGrp read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 4 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        long isisAdminGrp = cb.readUnsignedInt();
        return BgpLinkAttrIsIsAdminstGrp.of(isisAdminGrp);
    }

    public long linkAttrIsIsAdminGrp() {
        return this.isisAdminGrp;
    }

    @Override
    public short getType() {
        return 1088;
    }

    public int hashCode() {
        return Objects.hash(this.isisAdminGrp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrIsIsAdminstGrp) {
            BgpLinkAttrIsIsAdminstGrp other = (BgpLinkAttrIsIsAdminstGrp)obj;
            return Objects.equals(this.isisAdminGrp, other.isisAdminGrp);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("isisAdminGrp", this.isisAdminGrp).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

