/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPrefixAttrExtRouteTag
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpPrefixAttrExtRouteTag.class);
    public static final int ATTR_PREFIX_EXTROUTETAG = 1154;
    public static final int ATTR_PREFIX_EXT_LEN = 8;
    private List<Long> pfxExtRouteTag = new ArrayList<Long>();

    public BgpPrefixAttrExtRouteTag(List<Long> pfxExtRouteTag) {
        this.pfxExtRouteTag = (List)Preconditions.checkNotNull(pfxExtRouteTag);
    }

    public static BgpPrefixAttrExtRouteTag of(ArrayList<Long> pfxExtRouteTag) {
        return new BgpPrefixAttrExtRouteTag(pfxExtRouteTag);
    }

    public static BgpPrefixAttrExtRouteTag read(ChannelBuffer cb) throws BgpParseException {
        ArrayList<Long> pfxExtRouteTag = new ArrayList<Long>();
        short lsAttrLength = cb.readShort();
        int len = lsAttrLength / 8;
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        for (int i = 0; i < len; ++i) {
            long temp = cb.readLong();
            pfxExtRouteTag.add(new Long(temp));
        }
        return new BgpPrefixAttrExtRouteTag(pfxExtRouteTag);
    }

    public List<Long> pfxExtRouteTag() {
        return this.pfxExtRouteTag;
    }

    @Override
    public short getType() {
        return 1154;
    }

    public int hashCode() {
        return Objects.hash(this.pfxExtRouteTag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixAttrExtRouteTag) {
            BgpPrefixAttrExtRouteTag other = (BgpPrefixAttrExtRouteTag)obj;
            return Objects.equals(this.pfxExtRouteTag, other.pfxExtRouteTag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("pfxExtRouteTag", this.pfxExtRouteTag).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

