/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpKeepaliveMsg;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.types.BgpHeader;

public class BgpKeepaliveMsgTest {
    @Test
    public void keepaliveMessageTest1() throws BgpParseException {
        byte[] keepaliveMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(keepaliveMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpKeepaliveMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testKeepaliveMsg = new byte[readLen];
        buf.readBytes(testKeepaliveMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testKeepaliveMsg, (Matcher)Is.is((Object)keepaliveMsg));
    }
}

