/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.flowspec;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpFlowSpecPrefix
implements Comparable<Object> {
    private static final Logger log = LoggerFactory.getLogger(BgpFlowSpecPrefix.class);
    private final IpPrefix destinationPrefix;
    private final IpPrefix sourcePrefix;

    public BgpFlowSpecPrefix(IpPrefix destinationPrefix, IpPrefix sourcePrefix) {
        if (destinationPrefix == null) {
            destinationPrefix = IpPrefix.valueOf((int)0, (int)0);
        }
        if (sourcePrefix == null) {
            sourcePrefix = IpPrefix.valueOf((int)0, (int)0);
        }
        this.destinationPrefix = destinationPrefix;
        this.sourcePrefix = sourcePrefix;
    }

    public int hashCode() {
        return Objects.hash(this.destinationPrefix, this.sourcePrefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFlowSpecPrefix) {
            BgpFlowSpecPrefix other = (BgpFlowSpecPrefix)obj;
            if (this.destinationPrefix != null && this.sourcePrefix != null && this.destinationPrefix.equals((Object)other.destinationPrefix)) {
                return this.sourcePrefix.equals((Object)other.sourcePrefix);
            }
            if (this.destinationPrefix != null) {
                return this.destinationPrefix.equals((Object)other.destinationPrefix);
            }
            if (this.sourcePrefix != null) {
                return this.sourcePrefix.equals((Object)other.sourcePrefix);
            }
            return false;
        }
        return false;
    }

    public IpPrefix destinationPrefix() {
        return this.destinationPrefix;
    }

    public IpPrefix sourcePrefix() {
        return this.sourcePrefix;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("destinationPrefix", (Object)this.destinationPrefix).add("sourcePrefix", (Object)this.destinationPrefix).toString();
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o instanceof BgpFlowSpecPrefix) {
            ByteBuffer value2;
            ByteBuffer value1;
            BgpFlowSpecPrefix that = (BgpFlowSpecPrefix)o;
            if (this.destinationPrefix() != null) {
                if (this.destinationPrefix().prefixLength() == that.destinationPrefix().prefixLength()) {
                    value1 = ByteBuffer.wrap(this.destinationPrefix().address().toOctets());
                    int cmpVal = value1.compareTo(value2 = ByteBuffer.wrap(that.destinationPrefix().address().toOctets()));
                    if (cmpVal != 0) {
                        return cmpVal;
                    }
                } else {
                    if (this.destinationPrefix().prefixLength() > that.destinationPrefix().prefixLength()) {
                        return 1;
                    }
                    if (this.destinationPrefix().prefixLength() < that.destinationPrefix().prefixLength()) {
                        return -1;
                    }
                }
            }
            if (this.sourcePrefix() != null) {
                if (this.sourcePrefix().prefixLength() == that.sourcePrefix().prefixLength()) {
                    value1 = ByteBuffer.wrap(this.sourcePrefix().address().toOctets());
                    value2 = ByteBuffer.wrap(that.sourcePrefix().address().toOctets());
                    return value1.compareTo(value2);
                }
                if (this.sourcePrefix().prefixLength() > that.sourcePrefix().prefixLength()) {
                    return 1;
                }
                if (this.sourcePrefix().prefixLength() < that.sourcePrefix().prefixLength()) {
                    return -1;
                }
            }
            return 0;
        }
        return 1;
    }
}

