/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IPv4AddressTlv;
import org.onosproject.bgpio.types.IPv6AddressTlv;
import org.onosproject.bgpio.types.LinkLocalRemoteIdentifiersTlv;
import org.onosproject.bgpio.types.attr.BgpAttrNodeMultiTopologyId;
import org.onosproject.bgpio.util.UnSupportedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkLSIdentifier
implements Comparable<Object> {
    private static final Logger log = LoggerFactory.getLogger(BgpLinkLSIdentifier.class);
    public static final short IPV4_INTERFACE_ADDRESS_TYPE = 259;
    public static final short IPV4_NEIGHBOR_ADDRESS_TYPE = 260;
    public static final short IPV6_INTERFACE_ADDRESS_TYPE = 261;
    public static final short IPV6_NEIGHBOR_ADDRESS_TYPE = 262;
    private NodeDescriptors localNodeDescriptors;
    private NodeDescriptors remoteNodeDescriptors;
    private List<BgpValueType> linkDescriptor;

    public BgpLinkLSIdentifier() {
        this.localNodeDescriptors = null;
        this.remoteNodeDescriptors = null;
        this.linkDescriptor = null;
    }

    public BgpLinkLSIdentifier(NodeDescriptors localNodeDescriptors, NodeDescriptors remoteNodeDescriptors, LinkedList<BgpValueType> linkDescriptor) {
        this.localNodeDescriptors = (NodeDescriptors)Preconditions.checkNotNull((Object)localNodeDescriptors);
        this.remoteNodeDescriptors = (NodeDescriptors)Preconditions.checkNotNull((Object)remoteNodeDescriptors);
        this.linkDescriptor = (List)Preconditions.checkNotNull(linkDescriptor);
    }

    public static BgpLinkLSIdentifier parseLinkIdendifier(ChannelBuffer cb, byte protocolId) throws BgpParseException {
        NodeDescriptors localNodeDescriptors = new NodeDescriptors();
        localNodeDescriptors = BgpLinkLSIdentifier.parseNodeDescriptors(cb, (short)256, protocolId);
        NodeDescriptors remoteNodeDescriptors = new NodeDescriptors();
        remoteNodeDescriptors = BgpLinkLSIdentifier.parseNodeDescriptors(cb, (short)257, protocolId);
        LinkedList<BgpValueType> linkDescriptor = new LinkedList();
        linkDescriptor = BgpLinkLSIdentifier.parseLinkDescriptors(cb);
        return new BgpLinkLSIdentifier(localNodeDescriptors, remoteNodeDescriptors, linkDescriptor);
    }

    public static NodeDescriptors parseNodeDescriptors(ChannelBuffer cb, short desType, byte protocolId) throws BgpParseException {
        log.debug("parse Node descriptors");
        ChannelBuffer tempBuf = cb.copy();
        short type = cb.readShort();
        short length = cb.readShort();
        if (cb.readableBytes() < length) {
            throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 4));
        }
        NodeDescriptors nodeIdentifier = new NodeDescriptors();
        ChannelBuffer tempCb = cb.readBytes((int)length);
        if (type != desType) {
            throw new BgpParseException(3, 1, null);
        }
        nodeIdentifier = NodeDescriptors.read(tempCb, length, desType, protocolId);
        return nodeIdentifier;
    }

    public static LinkedList<BgpValueType> parseLinkDescriptors(ChannelBuffer cb) throws BgpParseException {
        LinkedList<BgpValueType> linkDescriptor = new LinkedList<BgpValueType>();
        BgpValueType tlv = null;
        int count = 0;
        while (cb.readableBytes() > 0) {
            ChannelBuffer tempBuf = cb.copy();
            short type = cb.readShort();
            short length = cb.readShort();
            if (cb.readableBytes() < length) {
                throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 4));
            }
            ChannelBuffer tempCb = cb.readBytes((int)length);
            switch (type) {
                case 258: {
                    tlv = LinkLocalRemoteIdentifiersTlv.read(tempCb);
                    break;
                }
                case 259: {
                    tlv = IPv4AddressTlv.read(tempCb, (short)259);
                    break;
                }
                case 260: {
                    tlv = IPv4AddressTlv.read(tempCb, (short)260);
                    break;
                }
                case 261: {
                    tlv = IPv6AddressTlv.read(tempCb, (short)261);
                    break;
                }
                case 262: {
                    tlv = IPv6AddressTlv.read(tempCb, (short)262);
                    break;
                }
                case 263: {
                    tlv = BgpAttrNodeMultiTopologyId.read(tempCb);
                    count = count++;
                    if (count <= 1) break;
                    throw new BgpParseException(3, 9, tempBuf.readBytes(length + 4));
                }
                default: {
                    UnSupportedAttribute.skipBytes(tempCb, length);
                }
            }
            linkDescriptor.add(tlv);
        }
        return linkDescriptor;
    }

    public NodeDescriptors localNodeDescriptors() {
        return this.localNodeDescriptors;
    }

    public NodeDescriptors remoteNodeDescriptors() {
        return this.remoteNodeDescriptors;
    }

    public List<BgpValueType> linkDescriptors() {
        return this.linkDescriptor;
    }

    public int hashCode() {
        return Objects.hash(this.linkDescriptor, this.localNodeDescriptors, this.remoteNodeDescriptors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkLSIdentifier) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            BgpLinkLSIdentifier other = (BgpLinkLSIdentifier)obj;
            Iterator<BgpValueType> objListIterator = other.linkDescriptor.iterator();
            countOtherSubTlv = other.linkDescriptor.size();
            countObjSubTlv = this.linkDescriptor.size();
            if (countObjSubTlv != countOtherSubTlv) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                BgpValueType subTlv = objListIterator.next();
                if (this.linkDescriptor.contains(subTlv) && other.linkDescriptor.contains(subTlv)) {
                    isCommonSubTlv = Objects.equals(this.linkDescriptor.get(this.linkDescriptor.indexOf(subTlv)), other.linkDescriptor.get(other.linkDescriptor.indexOf(subTlv)));
                    continue;
                }
                isCommonSubTlv = false;
            }
            return isCommonSubTlv && Objects.equals(this.localNodeDescriptors, other.localNodeDescriptors) && Objects.equals(this.remoteNodeDescriptors, other.remoteNodeDescriptors);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localNodeDescriptors", (Object)this.localNodeDescriptors).add("remoteNodeDescriptors", (Object)this.remoteNodeDescriptors).add("linkDescriptor", this.linkDescriptor).toString();
    }

    @Override
    public int compareTo(Object o) {
        int countObjSubTlv;
        if (this.equals(o)) {
            return 0;
        }
        boolean tlvFound = false;
        int result = this.localNodeDescriptors.compareTo(((BgpLinkLSIdentifier)o).localNodeDescriptors);
        if (result != 0) {
            return result;
        }
        if (this.remoteNodeDescriptors.compareTo(((BgpLinkLSIdentifier)o).remoteNodeDescriptors) != 0) {
            return this.remoteNodeDescriptors.compareTo(((BgpLinkLSIdentifier)o).remoteNodeDescriptors);
        }
        int countOtherSubTlv = ((BgpLinkLSIdentifier)o).linkDescriptor.size();
        if (countOtherSubTlv != (countObjSubTlv = this.linkDescriptor.size())) {
            if (countOtherSubTlv > countObjSubTlv) {
                return 1;
            }
            return -1;
        }
        ListIterator<BgpValueType> listIterator = this.linkDescriptor.listIterator();
        while (listIterator.hasNext()) {
            BgpValueType tlv1 = listIterator.next();
            for (BgpValueType tlv : ((BgpLinkLSIdentifier)o).linkDescriptor) {
                if (tlv.getType() != tlv1.getType()) continue;
                result = this.linkDescriptor.get(this.linkDescriptor.indexOf(tlv1)).compareTo(((BgpLinkLSIdentifier)o).linkDescriptor.get(((BgpLinkLSIdentifier)o).linkDescriptor.indexOf(tlv)));
                if (result != 0) {
                    return result;
                }
                tlvFound = true;
                break;
            }
            if (tlvFound) continue;
            return 1;
        }
        return 0;
    }
}

