/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpPrefixLSNlri;
import org.onosproject.bgpio.protocol.NlriType;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPrefixIPv4LSNlriVer4
implements BgpPrefixLSNlri {
    protected static final Logger log = LoggerFactory.getLogger(BgpPrefixIPv4LSNlriVer4.class);
    public static final int PREFIX_IPV4_NLRITYPE = 3;
    public static final int IDENTIFIER_LENGTH = 16;
    private long identifier;
    private byte protocolId;
    private RouteDistinguisher routeDistinguisher;
    private boolean isVpn;
    private BgpPrefixLSIdentifier bgpPrefixLSIdentifier;

    public BgpPrefixIPv4LSNlriVer4() {
        this.identifier = 0L;
        this.protocolId = 0;
        this.bgpPrefixLSIdentifier = null;
        this.routeDistinguisher = null;
        this.isVpn = false;
    }

    public BgpPrefixIPv4LSNlriVer4(long identifier, byte protocolId, BgpPrefixLSIdentifier bgpPrefixLSIdentifier, RouteDistinguisher routeDistinguisher, boolean isVpn) {
        this.identifier = identifier;
        this.protocolId = protocolId;
        this.bgpPrefixLSIdentifier = bgpPrefixLSIdentifier;
        this.routeDistinguisher = routeDistinguisher;
        this.isVpn = isVpn;
    }

    public static BgpPrefixIPv4LSNlriVer4 read(ChannelBuffer cb, short afi, byte safi) throws BgpParseException {
        boolean isVpn = false;
        RouteDistinguisher routeDistinguisher = null;
        if (afi == 16388 && safi == -128) {
            routeDistinguisher = new RouteDistinguisher();
            routeDistinguisher = RouteDistinguisher.read(cb);
            isVpn = true;
        } else {
            isVpn = false;
        }
        byte protocolId = cb.readByte();
        long identifier = cb.readLong();
        BgpPrefixLSIdentifier bgpPrefixLSIdentifier = new BgpPrefixLSIdentifier();
        bgpPrefixLSIdentifier = BgpPrefixLSIdentifier.parsePrefixIdendifier(cb, protocolId);
        return new BgpPrefixIPv4LSNlriVer4(identifier, protocolId, bgpPrefixLSIdentifier, routeDistinguisher, isVpn);
    }

    @Override
    public NlriType getNlriType() {
        return NlriType.PREFIX_IPV4;
    }

    @Override
    public NodeDescriptors getLocalNodeDescriptors() {
        return this.bgpPrefixLSIdentifier.getLocalNodeDescriptors();
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public void setPrefixLSIdentifier(BgpPrefixLSIdentifier bgpPrefixLSIdentifier) {
        this.bgpPrefixLSIdentifier = bgpPrefixLSIdentifier;
    }

    @Override
    public BgpNodeLSNlriVer4.ProtocolType getProtocolId() throws BgpParseException {
        switch (this.protocolId) {
            case 1: {
                return BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE;
            }
            case 2: {
                return BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
            }
            case 3: {
                return BgpNodeLSNlriVer4.ProtocolType.OSPF_V2;
            }
            case 4: {
                return BgpNodeLSNlriVer4.ProtocolType.DIRECT;
            }
            case 5: {
                return BgpNodeLSNlriVer4.ProtocolType.STATIC_CONFIGURATION;
            }
            case 6: {
                return BgpNodeLSNlriVer4.ProtocolType.OSPF_V3;
            }
        }
        throw new BgpParseException("protocol id not valid");
    }

    public boolean isVpnPresent() {
        return this.isVpn;
    }

    public BgpPrefixLSIdentifier getPrefixIdentifier() {
        return this.bgpPrefixLSIdentifier;
    }

    @Override
    public RouteDistinguisher getRouteDistinguisher() {
        return this.routeDistinguisher;
    }

    @Override
    public List<BgpValueType> getPrefixdescriptor() {
        return this.bgpPrefixLSIdentifier.getPrefixdescriptor();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("protocolId", (int)this.protocolId).add("identifier", this.identifier).add("RouteDistinguisher ", (Object)this.routeDistinguisher).add("bgpPrefixLSIdentifier", (Object)this.bgpPrefixLSIdentifier).toString();
    }
}

