/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.AreaIDTlv;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpLSIdentifierTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.IsIsPseudonode;
import org.onosproject.bgpio.types.OspfNonPseudonode;
import org.onosproject.bgpio.types.OspfPseudonode;
import org.onosproject.bgpio.util.UnSupportedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDescriptors {
    private static final Logger log = LoggerFactory.getLogger(NodeDescriptors.class);
    public static final short LOCAL_NODE_DES_TYPE = 256;
    public static final short REMOTE_NODE_DES_TYPE = 257;
    public static final short IGP_ROUTERID_TYPE = 515;
    public static final short IS_IS_LEVEL_1_PROTOCOL_ID = 1;
    public static final short IS_IS_LEVEL_2_PROTOCOL_ID = 2;
    public static final short OSPF_V2_PROTOCOL_ID = 3;
    public static final short OSPF_V3_PROTOCOL_ID = 6;
    public static final int TYPE_AND_LEN = 4;
    public static final int ISISNONPSEUDONODE_LEN = 6;
    public static final int ISISPSEUDONODE_LEN = 7;
    public static final int OSPFNONPSEUDONODE_LEN = 4;
    public static final int OSPFPSEUDONODE_LEN = 8;
    private List<BgpValueType> subTlvs;
    private short deslength;
    private short desType;

    public NodeDescriptors() {
        this.subTlvs = null;
        this.deslength = 0;
        this.desType = 0;
    }

    public NodeDescriptors(List<BgpValueType> subTlvs, short deslength, short desType) {
        this.subTlvs = subTlvs;
        this.deslength = deslength;
        this.desType = desType;
    }

    public List<BgpValueType> getSubTlvs() {
        return this.subTlvs;
    }

    public int hashCode() {
        return Objects.hash(this.subTlvs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeDescriptors) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            NodeDescriptors other = (NodeDescriptors)obj;
            Iterator<BgpValueType> objListIterator = other.subTlvs.iterator();
            countOtherSubTlv = other.subTlvs.size();
            countObjSubTlv = this.subTlvs.size();
            if (countObjSubTlv != countOtherSubTlv) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                BgpValueType subTlv = objListIterator.next();
                if (this.subTlvs.contains(subTlv) && other.subTlvs.contains(subTlv)) {
                    isCommonSubTlv = Objects.equals(this.subTlvs.get(this.subTlvs.indexOf(subTlv)), other.subTlvs.get(other.subTlvs.indexOf(subTlv)));
                    continue;
                }
                isCommonSubTlv = false;
            }
            return isCommonSubTlv;
        }
        return false;
    }

    public static NodeDescriptors read(ChannelBuffer cb, short desLength, short desType, byte protocolId) throws BgpParseException {
        log.debug("Read NodeDescriptor");
        LinkedList<BgpValueType> subTlvs = new LinkedList<BgpValueType>();
        BgpValueType tlv = null;
        while (cb.readableBytes() > 0) {
            ChannelBuffer tempBuf = cb.copy();
            short type = cb.readShort();
            short length = cb.readShort();
            if (cb.readableBytes() < length) {
                throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 4));
            }
            ChannelBuffer tempCb = cb.readBytes((int)length);
            switch (type) {
                case 512: {
                    tlv = AutonomousSystemTlv.read(tempCb);
                    break;
                }
                case 513: {
                    tlv = BgpLSIdentifierTlv.read(tempCb);
                    break;
                }
                case 514: {
                    tlv = AreaIDTlv.read(tempCb);
                    break;
                }
                case 515: {
                    if (protocolId == 1 || protocolId == 2) {
                        boolean isNonPseudoNode = true;
                        if (length == 7 && tempCb.getByte(6) != 0) {
                            isNonPseudoNode = false;
                        }
                        if (isNonPseudoNode) {
                            tlv = IsIsNonPseudonode.read(tempCb);
                            break;
                        }
                        tlv = IsIsPseudonode.read(tempCb);
                        break;
                    }
                    if (protocolId != 3 && protocolId != 6) break;
                    if (length == 4) {
                        tlv = OspfNonPseudonode.read(tempCb);
                        break;
                    }
                    if (length != 8) break;
                    tlv = OspfPseudonode.read(tempCb);
                    break;
                }
                default: {
                    UnSupportedAttribute.skipBytes(tempCb, length);
                }
            }
            subTlvs.add(tlv);
        }
        return new NodeDescriptors(subTlvs, desLength, desType);
    }

    public short getLength() {
        return this.deslength;
    }

    public short getType() {
        return this.desType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("desType", (int)this.desType).add("deslength", (int)this.deslength).add("subTlvs", this.subTlvs).toString();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        ListIterator<BgpValueType> listIterator = this.subTlvs.listIterator();
        int countOtherSubTlv = ((NodeDescriptors)o).subTlvs.size();
        int countObjSubTlv = this.subTlvs.size();
        boolean tlvFound = false;
        if (countOtherSubTlv != countObjSubTlv) {
            if (countOtherSubTlv > countObjSubTlv) {
                return 1;
            }
            return -1;
        }
        while (listIterator.hasNext()) {
            BgpValueType tlv1 = listIterator.next();
            log.debug("NodeDescriptor compare subtlv's");
            for (BgpValueType tlv : ((NodeDescriptors)o).subTlvs) {
                if (tlv.getType() != tlv1.getType()) continue;
                int result = this.subTlvs.get(this.subTlvs.indexOf(tlv1)).compareTo(((NodeDescriptors)o).subTlvs.get(((NodeDescriptors)o).subTlvs.indexOf(tlv)));
                if (result != 0) {
                    return result;
                }
                tlvFound = true;
                break;
            }
            if (tlvFound) continue;
            return 1;
        }
        return 0;
    }
}

