/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.ver4;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpMessageWriter;
import org.onosproject.bgpio.protocol.BgpNotificationMsg;
import org.onosproject.bgpio.protocol.BgpType;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.types.BgpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BgpNotificationMsgVer4
implements BgpNotificationMsg {
    private static final Logger log = LoggerFactory.getLogger(BgpNotificationMsgVer4.class);
    static final byte PACKET_VERSION = 4;
    static final int TOTAL_MESSAGE_MIN_LENGTH = 21;
    static final int PACKET_MINIMUM_LENGTH = 2;
    static final BgpType MSG_TYPE = BgpType.NOTIFICATION;
    static final byte DEFAULT_ERRORSUBCODE = 0;
    static final byte[] MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final byte MESSAGE_TYPE = 3;
    static final BgpHeader DEFAULT_MESSAGE_HEADER = new BgpHeader(MARKER, 19, 3);
    private byte errorCode;
    private byte errorSubCode;
    private byte[] data;
    private BgpHeader bgpHeader;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    public BgpNotificationMsgVer4() {
        this.bgpHeader = null;
        this.data = null;
        this.errorCode = 0;
        this.errorSubCode = 0;
    }

    public BgpNotificationMsgVer4(BgpHeader bgpHeader, byte errorCode, byte errorSubCode, byte[] data) {
        this.bgpHeader = bgpHeader;
        this.data = data;
        this.errorCode = errorCode;
        this.errorSubCode = errorSubCode;
    }

    @Override
    public BgpVersion getVersion() {
        return BgpVersion.BGP_4;
    }

    @Override
    public BgpType getType() {
        return BgpType.NOTIFICATION;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws BgpParseException {
        WRITER.write(cb, this);
    }

    @Override
    public byte getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(byte errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public byte getErrorSubCode() {
        return this.errorSubCode;
    }

    public void setErrorSubCode(byte errorSubCode) {
        this.errorSubCode = errorSubCode;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public BgpHeader getHeader() {
        return this.bgpHeader;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("bgpHeader", (Object)this.bgpHeader).add("data", (Object)this.data).add("errorCode", (int)this.errorCode).add("errorSubCode", (int)this.errorSubCode).toString();
    }

    static class Writer
    implements BgpMessageWriter<BgpNotificationMsgVer4> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, BgpNotificationMsgVer4 message) throws BgpParseException {
            int msgStartIndex = cb.writerIndex();
            int headerLenIndex = message.bgpHeader.write(cb);
            if (headerLenIndex <= 0) {
                throw new BgpParseException(1, 0, null);
            }
            cb.writeByte((int)message.errorCode);
            cb.writeByte((int)message.errorSubCode);
            if (message.data != null) {
                cb.writeBytes(message.data);
            }
            int length = cb.writerIndex() - msgStartIndex;
            cb.setShort(headerLenIndex, (int)((short)length));
            message.bgpHeader.setLength((short)length);
        }
    }

    static class Builder
    implements BgpNotificationMsg.Builder {
        private byte errorCode;
        private byte errorSubCode;
        private byte[] data;
        private BgpHeader bgpHeader;
        private boolean isErrorCodeSet = false;
        private boolean isErrorSubCodeSet = false;
        private boolean isBgpHeaderSet = false;

        Builder() {
        }

        @Override
        public BgpNotificationMsg build() throws BgpParseException {
            BgpHeader bgpHeader;
            BgpHeader bgpHeader2 = bgpHeader = this.isBgpHeaderSet ? this.bgpHeader : DEFAULT_MESSAGE_HEADER;
            if (!this.isErrorCodeSet) {
                throw new BgpParseException("Error code must be present");
            }
            byte errorSubCode = this.isErrorSubCodeSet ? this.errorSubCode : (byte)0;
            return new BgpNotificationMsgVer4(bgpHeader, this.errorCode, errorSubCode, this.data);
        }

        @Override
        public Builder setErrorCode(byte errorCode) {
            this.errorCode = errorCode;
            this.isErrorCodeSet = true;
            return this;
        }

        @Override
        public Builder setErrorSubCode(byte errorSubCode) {
            this.errorSubCode = errorSubCode;
            this.isErrorSubCodeSet = true;
            return this;
        }

        @Override
        public Builder setData(byte[] data) {
            if (data != null) {
                this.data = data;
            }
            return this;
        }

        @Override
        public Builder setHeader(BgpHeader bgpMsgHeader) {
            this.bgpHeader = bgpMsgHeader;
            return this;
        }
    }

    static class Reader
    implements BgpMessageReader<BgpNotificationMsg> {
        Reader() {
        }

        @Override
        public BgpNotificationMsg readFrom(ChannelBuffer cb, BgpHeader bgpHeader) throws BgpParseException {
            if (cb.readableBytes() < 2) {
                throw new BgpParseException("Not enough readable bytes");
            }
            byte errorCode = cb.readByte();
            byte errorSubCode = cb.readByte();
            int dataLength = bgpHeader.getLength() - 21;
            byte[] data = new byte[dataLength];
            cb.readBytes(data, 0, dataLength);
            return new BgpNotificationMsgVer4(bgpHeader, errorCode, errorSubCode, data);
        }
    }
}

