/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.ver4;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpMessageWriter;
import org.onosproject.bgpio.protocol.BgpType;
import org.onosproject.bgpio.protocol.BgpUpdateMsg;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.protocol.ver4.BgpPathAttributes;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpUpdateMsgVer4
implements BgpUpdateMsg {
    protected static final Logger log = LoggerFactory.getLogger(BgpUpdateMsgVer4.class);
    public static final byte PACKET_VERSION = 4;
    public static final int PACKET_MINIMUM_LENGTH = 4;
    public static final int MARKER_LENGTH = 16;
    public static final int BYTE_IN_BITS = 8;
    public static final int MIN_LEN_AFTER_WITHDRW_ROUTES = 2;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 19;
    public static final BgpType MSG_TYPE = BgpType.UPDATE;
    public static byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final BgpHeader DEFAULT_UPDATE_HEADER = new BgpHeader(marker, 4, 2);
    public static final Reader READER = new Reader();
    private List<IpPrefix> withdrawnRoutes;
    private BgpPathAttributes bgpPathAttributes;
    private BgpHeader bgpHeader;
    private List<IpPrefix> nlri;
    public static final Writer WRITER = new Writer();

    public BgpUpdateMsgVer4(BgpHeader bgpHeader, List<IpPrefix> withdrawnRoutes, BgpPathAttributes bgpPathAttributes, List<IpPrefix> nlri) {
        this.bgpHeader = bgpHeader;
        this.withdrawnRoutes = withdrawnRoutes;
        this.bgpPathAttributes = bgpPathAttributes;
        this.nlri = nlri;
    }

    public static LinkedList<IpPrefix> parseNlri(ChannelBuffer cb) throws BgpParseException {
        LinkedList<IpPrefix> nlri = new LinkedList<IpPrefix>();
        while (cb.readableBytes() > 0) {
            IpPrefix ipPrefix;
            byte length = cb.readByte();
            if (length == 0) {
                byte[] prefix = new byte[]{0};
                ipPrefix = Validation.bytesToPrefix(prefix, length);
                nlri.add(ipPrefix);
                continue;
            }
            int len = length / 8;
            int reminder = length % 8;
            if (reminder > 0) {
                ++len;
            }
            if (cb.readableBytes() < len) {
                Validation.validateLen((byte)3, (byte)1, cb.readableBytes());
            }
            byte[] prefix = new byte[len];
            cb.readBytes(prefix, 0, len);
            ipPrefix = Validation.bytesToPrefix(prefix, length);
            nlri.add(ipPrefix);
        }
        return nlri;
    }

    public static LinkedList<IpPrefix> parseWithdrawnRoutes(ChannelBuffer cb) throws BgpParseException {
        LinkedList<IpPrefix> withDrwRoutes = new LinkedList<IpPrefix>();
        while (cb.readableBytes() > 0) {
            IpPrefix ipPrefix;
            byte length = cb.readByte();
            if (length == 0) {
                byte[] prefix = new byte[]{0};
                ipPrefix = Validation.bytesToPrefix(prefix, length);
                withDrwRoutes.add(ipPrefix);
                continue;
            }
            int len = length / 8;
            int reminder = length % 8;
            if (reminder > 0) {
                ++len;
            }
            if (cb.readableBytes() < len) {
                Validation.validateLen((byte)3, (byte)1, cb.readableBytes());
            }
            byte[] prefix = new byte[len];
            cb.readBytes(prefix, 0, len);
            ipPrefix = Validation.bytesToPrefix(prefix, length);
            withDrwRoutes.add(ipPrefix);
        }
        return withDrwRoutes;
    }

    @Override
    public BgpVersion getVersion() {
        return BgpVersion.BGP_4;
    }

    @Override
    public BgpType getType() {
        return BgpType.UPDATE;
    }

    @Override
    public void writeTo(ChannelBuffer channelBuffer) {
        try {
            WRITER.write(channelBuffer, this);
        }
        catch (BgpParseException e) {
            log.debug("[writeTo] Error: " + e.toString());
        }
    }

    @Override
    public BgpPathAttributes bgpPathAttributes() {
        return this.bgpPathAttributes;
    }

    @Override
    public List<IpPrefix> withdrawnRoutes() {
        return this.withdrawnRoutes;
    }

    @Override
    public List<IpPrefix> nlri() {
        return this.nlri;
    }

    @Override
    public BgpHeader getHeader() {
        return this.bgpHeader;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("bgpHeader", (Object)this.bgpHeader).add("withDrawnRoutes", this.withdrawnRoutes).add("nlri", this.nlri).add("bgpPathAttributes", (Object)this.bgpPathAttributes).toString();
    }

    public static class Writer
    implements BgpMessageWriter<BgpUpdateMsgVer4> {
        @Override
        public void write(ChannelBuffer cb, BgpUpdateMsgVer4 message) throws BgpParseException {
            int startIndex = cb.writerIndex();
            short afi = 0;
            byte safi = 0;
            int msgLenIndex = message.bgpHeader.write(cb);
            if (msgLenIndex <= 0) {
                throw new BgpParseException("Unable to write message header.");
            }
            List<BgpValueType> pathAttr = message.bgpPathAttributes.pathAttributes();
            if (pathAttr != null) {
                for (BgpValueType attr : pathAttr) {
                    if (attr instanceof MpReachNlri) {
                        MpReachNlri mpReach = (MpReachNlri)attr;
                        afi = mpReach.afi();
                        safi = mpReach.safi();
                    } else if (attr instanceof MpUnReachNlri) {
                        MpUnReachNlri mpUnReach = (MpUnReachNlri)attr;
                        afi = mpUnReach.afi();
                        safi = mpUnReach.safi();
                    }
                    if (afi != 1 || safi != -123 && safi != -122) continue;
                    cb.writeShort(0);
                }
            }
            if (message.bgpPathAttributes != null) {
                message.bgpPathAttributes.write(cb);
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
            message.bgpHeader.setLength((short)length);
        }
    }

    static class Builder
    implements BgpUpdateMsg.Builder {
        BgpHeader bgpMsgHeader = null;
        BgpPathAttributes bgpPathAttributes;
        List<IpPrefix> withdrawnRoutes;
        List<IpPrefix> nlri;

        Builder() {
        }

        @Override
        public BgpUpdateMsg build() {
            BgpHeader bgpMsgHeader = DEFAULT_UPDATE_HEADER;
            return new BgpUpdateMsgVer4(bgpMsgHeader, this.withdrawnRoutes, this.bgpPathAttributes, this.nlri);
        }

        @Override
        public Builder setHeader(BgpHeader bgpMsgHeader) {
            this.bgpMsgHeader = bgpMsgHeader;
            return this;
        }

        @Override
        public Builder setBgpPathAttributes(List<BgpValueType> attributes) {
            this.bgpPathAttributes = new BgpPathAttributes(attributes);
            return this;
        }
    }

    static class Reader
    implements BgpMessageReader<BgpUpdateMsg> {
        Reader() {
        }

        @Override
        public BgpUpdateMsg readFrom(ChannelBuffer cb, BgpHeader bgpHeader) throws BgpParseException {
            if (cb.readableBytes() != bgpHeader.getLength() - 19) {
                Validation.validateLen((byte)3, (byte)2, bgpHeader.getLength());
            }
            LinkedList<IpPrefix> withDrwRoutes = new LinkedList();
            LinkedList<IpPrefix> nlri = new LinkedList();
            BgpPathAttributes bgpPathAttributes = new BgpPathAttributes();
            Short withDrwLen = cb.readShort();
            if (cb.readableBytes() < withDrwLen) {
                Validation.validateLen((byte)3, (byte)1, cb.readableBytes());
            }
            ChannelBuffer tempCb = cb.readBytes((int)withDrwLen.shortValue());
            if (withDrwLen != 0) {
                withDrwRoutes = BgpUpdateMsgVer4.parseWithdrawnRoutes(tempCb);
            }
            if (cb.readableBytes() < 2) {
                log.debug("Bgp Path Attribute len field not present");
                throw new BgpParseException(3, 1, null);
            }
            short totPathAttrLen = cb.readShort();
            int len = withDrwLen + totPathAttrLen + 4;
            if (len > bgpHeader.getLength()) {
                throw new BgpParseException(3, 1, null);
            }
            if (totPathAttrLen != 0) {
                if (cb.readableBytes() < totPathAttrLen) {
                    Validation.validateLen((byte)3, (byte)1, cb.readableBytes());
                }
                tempCb = cb.readBytes((int)totPathAttrLen);
                bgpPathAttributes = BgpPathAttributes.read(tempCb);
            }
            if (cb.readableBytes() > 0) {
                nlri = BgpUpdateMsgVer4.parseNlri(cb);
            }
            return new BgpUpdateMsgVer4(bgpHeader, withDrwRoutes, bgpPathAttributes, nlri);
        }
    }
}

