/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;

public class AutonomousSystemTlv
implements BgpValueType {
    public static final short TYPE = 512;
    public static final short LENGTH = 4;
    private final int asNum;

    public AutonomousSystemTlv(int asNum) {
        this.asNum = asNum;
    }

    public static AutonomousSystemTlv of(int asNum) {
        return new AutonomousSystemTlv(asNum);
    }

    public int getAsNum() {
        return this.asNum;
    }

    public int hashCode() {
        return Objects.hash(this.asNum);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutonomousSystemTlv) {
            AutonomousSystemTlv other = (AutonomousSystemTlv)obj;
            return Objects.equals(this.asNum, other.asNum);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(512);
        c.writeShort(4);
        c.writeInt(this.asNum);
        return c.writerIndex() - iLenStartIndex;
    }

    public static AutonomousSystemTlv read(ChannelBuffer c) {
        return AutonomousSystemTlv.of(c.readInt());
    }

    @Override
    public short getType() {
        return 512;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return Integer.valueOf(this.asNum).compareTo(((AutonomousSystemTlv)o).asNum);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 512).add("Length", 4).add("asNum", this.asNum).toString();
    }
}

