/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class IPReachabilityInformationTlv
implements BgpValueType {
    public static final short TYPE = 265;
    public static final int ONE_BYTE_LEN = 8;
    private byte prefixLen;
    private byte[] ipPrefix;
    public short length;

    public IPReachabilityInformationTlv(byte prefixLen, byte[] ipPrefix, short length) {
        this.ipPrefix = ipPrefix;
        this.prefixLen = prefixLen;
        this.length = length;
    }

    public IpPrefix getPrefixValue() {
        IpPrefix prefix = Validation.bytesToPrefix(this.ipPrefix, this.prefixLen);
        return prefix;
    }

    public byte getPrefixLen() {
        return this.prefixLen;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.ipPrefix), this.prefixLen);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPReachabilityInformationTlv) {
            IPReachabilityInformationTlv other = (IPReachabilityInformationTlv)obj;
            return Objects.equals(this.prefixLen, other.prefixLen) && Arrays.equals(this.ipPrefix, other.ipPrefix);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(265);
        cb.writeShort((int)this.length);
        cb.writeByte((int)this.prefixLen);
        cb.writeBytes(this.ipPrefix);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static IPReachabilityInformationTlv read(ChannelBuffer cb, short length) {
        byte[] prefix;
        byte preficLen = cb.readByte();
        if (preficLen == 0) {
            prefix = new byte[]{0};
        } else {
            int len = preficLen / 8;
            int reminder = preficLen % 8;
            if (reminder > 0) {
                ++len;
            }
            prefix = new byte[len];
            cb.readBytes(prefix, 0, len);
        }
        return IPReachabilityInformationTlv.of(preficLen, prefix, length);
    }

    public static IPReachabilityInformationTlv of(byte preficLen, byte[] prefix, short length) {
        return new IPReachabilityInformationTlv(preficLen, prefix, length);
    }

    @Override
    public short getType() {
        return 265;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        ByteBuffer value1 = ByteBuffer.wrap(this.ipPrefix);
        ByteBuffer value2 = ByteBuffer.wrap(((IPReachabilityInformationTlv)o).ipPrefix);
        return value1.compareTo(value2);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 265).add("Length", (int)this.length).add("Prefixlength", (int)this.getPrefixLen()).add("Prefixvalue", (Object)this.getPrefixValue()).toString();
    }
}

