/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onlab.packet.Ip4Address;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecDetails;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.types.BgpFsDestinationPortNum;
import org.onosproject.bgpio.types.BgpFsDestinationPrefix;
import org.onosproject.bgpio.types.BgpFsDscpValue;
import org.onosproject.bgpio.types.BgpFsFragment;
import org.onosproject.bgpio.types.BgpFsIcmpCode;
import org.onosproject.bgpio.types.BgpFsIcmpType;
import org.onosproject.bgpio.types.BgpFsIpProtocol;
import org.onosproject.bgpio.types.BgpFsPacketLength;
import org.onosproject.bgpio.types.BgpFsPortNum;
import org.onosproject.bgpio.types.BgpFsSourcePortNum;
import org.onosproject.bgpio.types.BgpFsSourcePrefix;
import org.onosproject.bgpio.types.BgpFsTcpFlags;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpReachNlri
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(MpReachNlri.class);
    public static final byte MPREACHNLRI_TYPE = 14;
    public static final byte LINK_NLRITYPE = 2;
    public static final byte FLAGS = -112;
    public static final short FLOW_SPEC_LEN = 240;
    private boolean isMpReachNlri = false;
    private final List<BgpLSNlri> mpReachNlri;
    private final int length;
    private final short afi;
    private final byte safi;
    private final Ip4Address ipNextHop;
    private BgpFlowSpecDetails bgpFlowSpecInfo;

    public MpReachNlri(List<BgpLSNlri> mpReachNlri, short afi, byte safi, Ip4Address ipNextHop, int length) {
        this.mpReachNlri = mpReachNlri;
        this.isMpReachNlri = true;
        this.ipNextHop = ipNextHop;
        this.afi = afi;
        this.safi = safi;
        this.length = length;
    }

    public MpReachNlri(BgpFlowSpecDetails bgpFlowSpecInfo, short afi, byte safi) {
        this.mpReachNlri = null;
        this.isMpReachNlri = true;
        this.length = 0;
        this.ipNextHop = null;
        this.bgpFlowSpecInfo = bgpFlowSpecInfo;
        this.afi = afi;
        this.safi = safi;
    }

    public boolean isMpReachNlriSet() {
        return this.isMpReachNlri;
    }

    public List<BgpLSNlri> mpReachNlri() {
        return this.mpReachNlri;
    }

    public int mpReachNlriLen() {
        return this.length;
    }

    public BgpFlowSpecDetails bgpFlowSpecInfo() {
        return this.bgpFlowSpecInfo;
    }

    public static MpReachNlri read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempBuf = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempBuf.readBytes(len);
        if (cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        if (!parseFlags.getFirstBit() && parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        BgpLSNlri bgpLSNlri = null;
        LinkedList<BgpLSNlri> mpReachNlri = new LinkedList<BgpLSNlri>();
        ChannelBuffer tempCb = cb.readBytes(parseFlags.getLength());
        short afi = 0;
        byte safi = 0;
        Ip4Address ipNextHop = null;
        while (tempCb.readableBytes() > 0) {
            afi = tempCb.readShort();
            safi = tempCb.readByte();
            if (afi == 16388 && safi == 71 || afi == 16388 && safi == -128) {
                byte nextHopLen = tempCb.readByte();
                InetAddress ipAddress = Validation.toInetAddress(nextHopLen, tempCb);
                if (ipAddress.isMulticastAddress()) {
                    throw new BgpParseException("Multicast not supported");
                }
                ipNextHop = Ip4Address.valueOf((InetAddress)ipAddress);
                byte reserved = tempCb.readByte();
                while (tempCb.readableBytes() > 0) {
                    short nlriType = tempCb.readShort();
                    short totNlriLen = tempCb.readShort();
                    if (tempCb.readableBytes() < totNlriLen) {
                        Validation.validateLen((byte)3, (byte)5, totNlriLen);
                    }
                    tempBuf = tempCb.readBytes((int)totNlriLen);
                    switch (nlriType) {
                        case 1: {
                            bgpLSNlri = BgpNodeLSNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        case 2: {
                            bgpLSNlri = BgpLinkLsNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        case 3: {
                            bgpLSNlri = BgpPrefixIPv4LSNlriVer4.read(tempBuf, afi, safi);
                            break;
                        }
                        default: {
                            log.debug("nlriType not supported" + nlriType);
                        }
                    }
                    mpReachNlri.add(bgpLSNlri);
                }
                continue;
            }
            if (afi == 1 && (safi == -123 || safi == -122)) {
                LinkedList<BgpValueType> flowSpecComponents = new LinkedList<BgpValueType>();
                RouteDistinguisher routeDistinguisher = null;
                if (tempCb.readableBytes() > 0) {
                    short totNlriLen;
                    BgpValueType flowSpecComponent = null;
                    byte nextHopLen = tempCb.readByte();
                    if (nextHopLen > 0) {
                        InetAddress ipAddress = Validation.toInetAddress(nextHopLen, tempCb);
                        if (ipAddress.isMulticastAddress()) {
                            throw new BgpParseException("Multicast not supported");
                        }
                        ipNextHop = Ip4Address.valueOf((InetAddress)ipAddress);
                    }
                    byte reserved = tempCb.readByte();
                    if (safi == -122) {
                        routeDistinguisher = new RouteDistinguisher();
                        routeDistinguisher = RouteDistinguisher.read(tempCb);
                    }
                    totNlriLen = (totNlriLen = (short)tempCb.getByte(tempCb.readerIndex())) >= 240 ? tempCb.readShort() : (short)tempCb.readByte();
                    if (tempCb.readableBytes() < totNlriLen) {
                        Validation.validateLen((byte)3, (byte)5, totNlriLen);
                    }
                    tempBuf = tempCb.readBytes((int)totNlriLen);
                    while (tempBuf.readableBytes() > 0) {
                        short type = tempBuf.readByte();
                        switch (type) {
                            case 1: {
                                flowSpecComponent = BgpFsDestinationPrefix.read(tempBuf);
                                break;
                            }
                            case 2: {
                                flowSpecComponent = BgpFsSourcePrefix.read(tempBuf);
                                break;
                            }
                            case 3: {
                                flowSpecComponent = BgpFsIpProtocol.read(tempBuf);
                                break;
                            }
                            case 4: {
                                flowSpecComponent = BgpFsPortNum.read(tempBuf);
                                break;
                            }
                            case 5: {
                                flowSpecComponent = BgpFsDestinationPortNum.read(tempBuf);
                                break;
                            }
                            case 6: {
                                flowSpecComponent = BgpFsSourcePortNum.read(tempBuf);
                                break;
                            }
                            case 7: {
                                flowSpecComponent = BgpFsIcmpType.read(tempBuf);
                                break;
                            }
                            case 8: {
                                flowSpecComponent = BgpFsIcmpCode.read(tempBuf);
                                break;
                            }
                            case 9: {
                                flowSpecComponent = BgpFsTcpFlags.read(tempBuf);
                                break;
                            }
                            case 10: {
                                flowSpecComponent = BgpFsPacketLength.read(tempBuf);
                                break;
                            }
                            case 11: {
                                flowSpecComponent = BgpFsDscpValue.read(tempBuf);
                                break;
                            }
                            case 12: {
                                flowSpecComponent = BgpFsFragment.read(tempBuf);
                                break;
                            }
                            default: {
                                log.debug("flow spec type not supported" + type);
                            }
                        }
                        flowSpecComponents.add(flowSpecComponent);
                    }
                }
                BgpFlowSpecDetails flowSpecDetails = new BgpFlowSpecDetails(flowSpecComponents);
                flowSpecDetails.setRouteDistinguiher(routeDistinguisher);
                return new MpReachNlri(flowSpecDetails, afi, safi);
            }
            throw new BgpParseException("Not Supporting afi " + afi + "safi " + safi);
        }
        return new MpReachNlri(mpReachNlri, afi, safi, ipNextHop, parseFlags.getLength());
    }

    @Override
    public short getType() {
        return 14;
    }

    public short afi() {
        return this.afi;
    }

    public Ip4Address nexthop4() {
        return this.ipNextHop;
    }

    public byte safi() {
        return this.safi;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        if (this.afi == 1 && (this.safi == -123 || this.safi == -122)) {
            cb.writeByte(-112);
            cb.writeByte(14);
            int mpReachDataIndx = cb.writerIndex();
            cb.writeShort(0);
            cb.writeShort((int)this.afi);
            cb.writeByte((int)this.safi);
            cb.writeByte(0);
            cb.writeByte(0);
            if (this.bgpFlowSpecInfo.routeDistinguisher() != null) {
                cb.writeLong(this.bgpFlowSpecInfo.routeDistinguisher().getRouteDistinguisher());
            }
            ChannelBuffer flowSpecTmpBuff = ChannelBuffers.dynamicBuffer();
            int tmpBuffStartIndx = flowSpecTmpBuff.writerIndex();
            List<BgpValueType> flowSpec = this.bgpFlowSpecInfo.flowSpecComponents();
            ListIterator<BgpValueType> listIterator = flowSpec.listIterator();
            while (listIterator.hasNext()) {
                BgpValueType tlv = listIterator.next();
                switch (tlv.getType()) {
                    case 1: {
                        BgpFsDestinationPrefix fsDstPrefix = (BgpFsDestinationPrefix)tlv;
                        fsDstPrefix.write(flowSpecTmpBuff);
                        break;
                    }
                    case 2: {
                        BgpFsSourcePrefix fsSrcPrefix = (BgpFsSourcePrefix)tlv;
                        fsSrcPrefix.write(flowSpecTmpBuff);
                        break;
                    }
                    case 3: {
                        BgpFsIpProtocol fsIpProtocol = (BgpFsIpProtocol)tlv;
                        fsIpProtocol.write(flowSpecTmpBuff);
                        break;
                    }
                    case 4: {
                        BgpFsPortNum fsPortNum = (BgpFsPortNum)tlv;
                        fsPortNum.write(flowSpecTmpBuff);
                        break;
                    }
                    case 5: {
                        BgpFsDestinationPortNum fsDstPortNum = (BgpFsDestinationPortNum)tlv;
                        fsDstPortNum.write(flowSpecTmpBuff);
                        break;
                    }
                    case 6: {
                        BgpFsSourcePortNum fsSrcPortNum = (BgpFsSourcePortNum)tlv;
                        fsSrcPortNum.write(flowSpecTmpBuff);
                        break;
                    }
                    case 7: {
                        BgpFsIcmpType fsIcmpType = (BgpFsIcmpType)tlv;
                        fsIcmpType.write(flowSpecTmpBuff);
                        break;
                    }
                    case 8: {
                        BgpFsIcmpCode fsIcmpCode = (BgpFsIcmpCode)tlv;
                        fsIcmpCode.write(flowSpecTmpBuff);
                        break;
                    }
                    case 9: {
                        BgpFsTcpFlags fsTcpFlags = (BgpFsTcpFlags)tlv;
                        fsTcpFlags.write(flowSpecTmpBuff);
                        break;
                    }
                    case 10: {
                        BgpFsPacketLength fsPacketLen = (BgpFsPacketLength)tlv;
                        fsPacketLen.write(flowSpecTmpBuff);
                        break;
                    }
                    case 11: {
                        BgpFsDscpValue fsDscpVal = (BgpFsDscpValue)tlv;
                        fsDscpVal.write(flowSpecTmpBuff);
                        break;
                    }
                    case 12: {
                        BgpFsFragment fsFragment = (BgpFsFragment)tlv;
                        fsFragment.write(flowSpecTmpBuff);
                        break;
                    }
                }
            }
            int len = flowSpecTmpBuff.writerIndex() - tmpBuffStartIndx;
            if (len >= 240) {
                cb.writeShort(len);
            } else {
                cb.writeByte(len);
            }
            cb.writeBytes(flowSpecTmpBuff);
            int fsNlriLen = cb.writerIndex() - mpReachDataIndx;
            cb.setShort(mpReachDataIndx, (int)((short)(fsNlriLen - 2)));
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("mpReachNlri", this.mpReachNlri).add("bgpFlowSpecInfo", (Object)this.bgpFlowSpecInfo).add("afi", (int)this.afi).add("safi", (int)this.safi).add("ipNextHop", (Object)this.ipNextHop).add("length", this.length).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

