/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProtocolExtnCapabilityTlv
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(MultiProtocolExtnCapabilityTlv.class);
    public static final byte TYPE = 1;
    public static final byte LENGTH = 4;
    private final short afi;
    private final byte res;
    private final byte safi;

    public MultiProtocolExtnCapabilityTlv(short afi, byte res, byte safi) {
        this.afi = afi;
        this.res = res;
        this.safi = safi;
    }

    public static MultiProtocolExtnCapabilityTlv of(short afi, byte res, byte safi) {
        return new MultiProtocolExtnCapabilityTlv(afi, res, safi);
    }

    public short getAfi() {
        return this.afi;
    }

    public byte getRes() {
        return this.res;
    }

    public byte getSafi() {
        return this.safi;
    }

    @Override
    public short getType() {
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.afi, this.res, this.safi);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiProtocolExtnCapabilityTlv) {
            MultiProtocolExtnCapabilityTlv other = (MultiProtocolExtnCapabilityTlv)obj;
            return Objects.equals(this.afi, other.afi) && Objects.equals(this.res, other.res) && Objects.equals(this.safi, other.safi);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(1);
        cb.writeByte(4);
        cb.writeShort((int)this.afi);
        cb.writeByte((int)this.res);
        cb.writeByte((int)this.safi);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpValueType read(ChannelBuffer cb) {
        short afi = cb.readShort();
        byte res = cb.readByte();
        byte safi = cb.readByte();
        return new MultiProtocolExtnCapabilityTlv(afi, res, safi);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1).add("Length", 4).add("AFI", (int)this.afi).add("Reserved", (int)this.res).add("SAFI", (int)this.safi).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

