/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.ver4.BgpUpdateMsgVer4;
import org.onosproject.bgpio.types.BgpHeader;

public class MpReachNlriTest {
    @Test
    public void mpReachNlriTest1() throws BgpParseException {
        byte[] flowSpecMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 74, 2, 0, 0, 0, 51, 64, 1, 1, 0, 64, 2, 4, 2, 1, 0, 100, -128, 4, 4, 0, 0, 0, 0, -64, 16, 8, -128, 6, 0, 0, 0, 0, 0, 0, -112, 14, 0, 18, 0, 1, -123, 0, 0, 12, 2, 32, -64, -88, 7, 54, 3, -127, 103, 4, -127, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(flowSpecMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsgVer4.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testFsMsg = new byte[readLen];
        buf.readBytes(testFsMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testFsMsg, (Matcher)Is.is((Object)flowSpecMsg));
    }

    @Test
    public void mpReachNlriTest2() throws BgpParseException {
        byte[] flowSpecMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 82, 2, 0, 0, 0, 59, 64, 1, 1, 1, 64, 2, 4, 2, 1, 0, -56, -128, 4, 4, 0, 0, 0, 0, -64, 16, 16, -128, 6, 0, 123, 64, 96, 0, 0, -128, 9, 0, 0, 0, 0, 0, 15, -112, 14, 0, 18, 0, 1, -123, 0, 0, 12, 1, 30, -64, -88, 2, 0, 2, 30, -64, -88, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(flowSpecMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsgVer4.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testFsMsg = new byte[readLen];
        buf.readBytes(testFsMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testFsMsg, (Matcher)Is.is((Object)flowSpecMsg));
    }

    @Test
    public void mpReachNlriTest3() throws BgpParseException {
        byte[] flowSpecMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 113, 2, 0, 0, 0, 90, 64, 1, 1, 1, 64, 2, 4, 2, 1, 0, -56, -128, 4, 4, 0, 0, 0, 0, -64, 16, 16, -128, 6, 0, 123, 64, 96, 0, 0, -128, 9, 0, 0, 0, 0, 0, 15, -112, 14, 0, 49, 0, 1, -123, 0, 0, 43, 1, 30, -64, -88, 2, 0, 2, 30, -64, -88, 1, 0, 3, -128, 4, 4, -128, -77, 5, -128, -56, 6, -128, 100, 7, -128, 123, 8, -128, -22, 9, -128, 123, 10, -112, 3, -24, 11, -128, 123, 12, -128, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(flowSpecMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsgVer4.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testFsMsg = new byte[readLen];
        buf.readBytes(testFsMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testFsMsg, (Matcher)Is.is((Object)flowSpecMsg));
    }
}

