/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpLinkLsNlri;
import org.onosproject.bgpio.protocol.NlriType;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkLsNlriVer4
implements BgpLinkLsNlri {
    private static final Logger log = LoggerFactory.getLogger(BgpLinkLsNlriVer4.class);
    public static final int LINK_NLRITYPE = 2;
    private BgpLinkLSIdentifier linkLSIdentifier;
    private byte protocolId;
    private long identifier;
    private RouteDistinguisher routeDistinguisher;
    private boolean isVpn;

    public BgpLinkLsNlriVer4() {
        this.protocolId = 0;
        this.identifier = 0L;
        this.linkLSIdentifier = null;
        this.routeDistinguisher = null;
        this.isVpn = false;
    }

    public BgpLinkLsNlriVer4(byte protocolId, long identifier, BgpLinkLSIdentifier linkLSIdentifier, RouteDistinguisher routeDistinguisher, boolean isVpn) {
        this.protocolId = protocolId;
        this.identifier = identifier;
        this.linkLSIdentifier = linkLSIdentifier;
        this.routeDistinguisher = routeDistinguisher;
        this.isVpn = isVpn;
    }

    public static BgpLinkLsNlriVer4 read(ChannelBuffer cb, short afi, byte safi) throws BgpParseException {
        boolean isVpn = false;
        RouteDistinguisher routeDistinguisher = null;
        if (afi == 16388 && safi == -128) {
            routeDistinguisher = new RouteDistinguisher();
            routeDistinguisher = RouteDistinguisher.read(cb);
            isVpn = true;
        } else {
            isVpn = false;
        }
        byte protocolId = cb.readByte();
        long identifier = cb.readLong();
        BgpLinkLSIdentifier linkLSIdentifier = new BgpLinkLSIdentifier();
        linkLSIdentifier = BgpLinkLSIdentifier.parseLinkIdendifier(cb, protocolId);
        return new BgpLinkLsNlriVer4(protocolId, identifier, linkLSIdentifier, routeDistinguisher, isVpn);
    }

    @Override
    public NlriType getNlriType() {
        return NlriType.LINK;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public void setLinkLSIdentifier(BgpLinkLSIdentifier linkLSIdentifier) {
        this.linkLSIdentifier = linkLSIdentifier;
    }

    @Override
    public BgpNodeLSNlriVer4.ProtocolType getProtocolId() throws BgpParseException {
        switch (this.protocolId) {
            case 1: {
                return BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE;
            }
            case 2: {
                return BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
            }
            case 3: {
                return BgpNodeLSNlriVer4.ProtocolType.OSPF_V2;
            }
            case 4: {
                return BgpNodeLSNlriVer4.ProtocolType.DIRECT;
            }
            case 5: {
                return BgpNodeLSNlriVer4.ProtocolType.STATIC_CONFIGURATION;
            }
            case 6: {
                return BgpNodeLSNlriVer4.ProtocolType.OSPF_V3;
            }
        }
        throw new BgpParseException(3, 0, null);
    }

    @Override
    public NodeDescriptors localNodeDescriptors() {
        return this.linkLSIdentifier.localNodeDescriptors();
    }

    @Override
    public NodeDescriptors remoteNodeDescriptors() {
        return this.linkLSIdentifier.remoteNodeDescriptors();
    }

    public boolean isVpnPresent() {
        return this.isVpn;
    }

    @Override
    public RouteDistinguisher getRouteDistinguisher() {
        return this.routeDistinguisher;
    }

    public BgpLinkLSIdentifier getLinkIdentifier() {
        return this.linkLSIdentifier;
    }

    @Override
    public List<BgpValueType> linkDescriptors() {
        return this.linkLSIdentifier.linkDescriptors();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("protocolId", (int)this.protocolId).add("identifier", this.identifier).add("RouteDistinguisher ", (Object)this.routeDistinguisher).add("linkLSIdentifier", (Object)this.linkLSIdentifier).toString();
    }
}

