/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.ver4;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpKeepaliveMsg;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpMessageWriter;
import org.onosproject.bgpio.protocol.BgpType;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.types.BgpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpKeepaliveMsgVer4
implements BgpKeepaliveMsg {
    protected static final Logger log = LoggerFactory.getLogger(BgpKeepaliveMsgVer4.class);
    private BgpHeader bgpMsgHeader;
    public static final byte PACKET_VERSION = 4;
    public static final int PACKET_MINIMUM_LENGTH = 19;
    public static final int MARKER_LENGTH = 16;
    public static final BgpType MSG_TYPE = BgpType.KEEP_ALIVE;
    public static byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    @Override
    public void writeTo(ChannelBuffer cb) {
        WRITER.write(cb, this);
    }

    @Override
    public BgpVersion getVersion() {
        return BgpVersion.BGP_4;
    }

    @Override
    public BgpType getType() {
        return MSG_TYPE;
    }

    @Override
    public BgpHeader getHeader() {
        return this.bgpMsgHeader;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).toString();
    }

    static class Writer
    implements BgpMessageWriter<BgpKeepaliveMsgVer4> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, BgpKeepaliveMsgVer4 message) {
            cb.writeBytes(marker, 0, 16);
            cb.writeShort(19);
            cb.writeByte((int)MSG_TYPE.getType());
        }
    }

    static class Builder
    implements BgpKeepaliveMsg.Builder {
        BgpHeader bgpMsgHeader;

        Builder() {
        }

        @Override
        public Builder setHeader(BgpHeader bgpMsgHeader) {
            this.bgpMsgHeader = bgpMsgHeader;
            return this;
        }

        @Override
        public BgpKeepaliveMsg build() {
            return new BgpKeepaliveMsgVer4();
        }
    }

    static class Reader
    implements BgpMessageReader<BgpKeepaliveMsg> {
        Reader() {
        }

        @Override
        public BgpKeepaliveMsg readFrom(ChannelBuffer cb, BgpHeader bgpHeader) throws BgpParseException {
            return new BgpKeepaliveMsgVer4();
        }
    }
}

