/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.ver4;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpMessageWriter;
import org.onosproject.bgpio.protocol.BgpOpenMsg;
import org.onosproject.bgpio.protocol.BgpType;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.FourOctetAsNumCapabilityTlv;
import org.onosproject.bgpio.types.MultiProtocolExtnCapabilityTlv;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpOpenMsgVer4
implements BgpOpenMsg {
    protected static final Logger log = LoggerFactory.getLogger(BgpOpenMsgVer4.class);
    public static final byte PACKET_VERSION = 4;
    public static final int OPEN_MSG_MINIMUM_LENGTH = 10;
    public static final int MSG_HEADER_LENGTH = 19;
    public static final int MARKER_LENGTH = 16;
    public static final int DEFAULT_HOLD_TIME = 120;
    public static final short AS_TRANS = 23456;
    public static final int OPT_PARA_TYPE_CAPABILITY = 2;
    public static final BgpType MSG_TYPE = BgpType.OPEN;
    public static final short AFI = 16388;
    public static final byte SAFI = 71;
    public static final byte RES = 0;
    public static final int FOUR_OCTET_AS_NUM_CAPA_TYPE = 65;
    public static final byte[] MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final BgpHeader DEFAULT_OPEN_HEADER = new BgpHeader(MARKER, 10, 1);
    private BgpHeader bgpMsgHeader;
    private byte version;
    private short asNumber;
    private short holdTime;
    private int bgpId;
    private boolean isLargeAsCapabilitySet;
    private LinkedList<BgpValueType> capabilityTlv;
    public static final Reader READER = new Reader();
    public static final Writer WRITER = new Writer();

    public BgpOpenMsgVer4() {
        this.bgpMsgHeader = null;
        this.version = 0;
        this.holdTime = 0;
        this.asNumber = 0;
        this.bgpId = 0;
        this.capabilityTlv = null;
    }

    public BgpOpenMsgVer4(BgpHeader bgpMsgHeader, byte version, short asNumber, short holdTime, int bgpId, LinkedList<BgpValueType> capabilityTlv) {
        this.bgpMsgHeader = bgpMsgHeader;
        this.version = version;
        this.asNumber = asNumber;
        this.holdTime = holdTime;
        this.bgpId = bgpId;
        this.capabilityTlv = capabilityTlv;
    }

    @Override
    public BgpHeader getHeader() {
        return this.bgpMsgHeader;
    }

    @Override
    public BgpVersion getVersion() {
        return BgpVersion.BGP_4;
    }

    @Override
    public BgpType getType() {
        return MSG_TYPE;
    }

    @Override
    public short getHoldTime() {
        return this.holdTime;
    }

    @Override
    public short getAsNumber() {
        return this.asNumber;
    }

    @Override
    public int getBgpId() {
        return this.bgpId;
    }

    @Override
    public LinkedList<BgpValueType> getCapabilityTlv() {
        return this.capabilityTlv;
    }

    protected static LinkedList<BgpValueType> parseCapabilityTlv(ChannelBuffer cb) throws BgpParseException {
        LinkedList<BgpValueType> capabilityTlv = new LinkedList<BgpValueType>();
        block4: while (cb.readableBytes() > 0) {
            BgpValueType tlv;
            short type = cb.readByte();
            short length = cb.readByte();
            switch (type) {
                case 65: {
                    log.debug("FourOctetAsNumCapabilityTlv");
                    if (4 != length) {
                        throw new BgpParseException("Invalid length received for FourOctetAsNumCapabilityTlv.");
                    }
                    if (length > cb.readableBytes()) {
                        throw new BgpParseException("Four octet as num tlv length is more than readableBytes.");
                    }
                    int as4Num = cb.readInt();
                    tlv = new FourOctetAsNumCapabilityTlv(as4Num);
                    break;
                }
                case 1: {
                    log.debug("MultiProtocolExtnCapabilityTlv");
                    if (4 != length) {
                        throw new BgpParseException("Invalid length received for MultiProtocolExtnCapabilityTlv.");
                    }
                    if (length > cb.readableBytes()) {
                        throw new BgpParseException("BGP LS tlv length is more than readableBytes.");
                    }
                    short afi = cb.readShort();
                    byte res = cb.readByte();
                    byte safi = cb.readByte();
                    tlv = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
                    break;
                }
                default: {
                    log.debug("Warning: Unsupported TLV: " + type);
                    cb.skipBytes((int)length);
                    continue block4;
                }
            }
            capabilityTlv.add(tlv);
        }
        return capabilityTlv;
    }

    @Override
    public void writeTo(ChannelBuffer cb) {
        try {
            WRITER.write(cb, this);
        }
        catch (BgpParseException e) {
            log.debug("[writeTo] Error: " + e.toString());
        }
    }

    protected int packCapabilityTlv(ChannelBuffer cb, BgpOpenMsgVer4 message) {
        int startIndex = cb.writerIndex();
        int capParaLen = 0;
        int capParaLenIndex = 0;
        LinkedList<BgpValueType> capabilityTlv = message.capabilityTlv;
        ListIterator listIterator = capabilityTlv.listIterator();
        if (listIterator.hasNext()) {
            cb.writeByte(2);
            capParaLenIndex = cb.writerIndex();
            cb.writeByte(0);
            startIndex = cb.writerIndex();
        }
        while (listIterator.hasNext()) {
            BgpValueType tlv = (BgpValueType)listIterator.next();
            if (tlv == null) {
                log.debug("Warning: tlv is null from CapabilityTlv list");
                continue;
            }
            tlv.write(cb);
        }
        capParaLen = cb.writerIndex() - startIndex;
        if (capParaLen != 0) {
            cb.setByte(capParaLenIndex, (int)((byte)capParaLen));
        }
        return capParaLen;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("bgpMsgHeader", (Object)this.bgpMsgHeader).add("version", (int)this.version).add("holdTime", (int)this.holdTime).add("asNumber", (int)this.asNumber).add("bgpId", this.bgpId).add("capabilityTlv", this.capabilityTlv).toString();
    }

    public static class Writer
    implements BgpMessageWriter<BgpOpenMsgVer4> {
        @Override
        public void write(ChannelBuffer cb, BgpOpenMsgVer4 message) throws BgpParseException {
            int optParaLen = 0;
            int as4num = 0;
            int startIndex = cb.writerIndex();
            int msgLenIndex = message.bgpMsgHeader.write(cb);
            if (msgLenIndex <= 0) {
                throw new BgpParseException("Unable to write message header.");
            }
            cb.writeByte((int)message.version);
            if (message.isLargeAsCapabilitySet) {
                LinkedList<BgpValueType> capabilityTlv = message.getCapabilityTlv();
                ListIterator listIterator = capabilityTlv.listIterator();
                while (listIterator.hasNext()) {
                    BgpValueType tlv = (BgpValueType)listIterator.next();
                    if (tlv.getType() != 65) continue;
                    as4num = ((FourOctetAsNumCapabilityTlv)tlv).getInt();
                    break;
                }
            }
            if (message.isLargeAsCapabilitySet && as4num > 65535) {
                cb.writeShort(23456);
            } else {
                cb.writeShort((int)message.asNumber);
            }
            cb.writeShort((int)message.holdTime);
            cb.writeInt(message.bgpId);
            int optParaLenIndex = cb.writerIndex();
            cb.writeByte(0);
            optParaLen = message.packCapabilityTlv(cb, message);
            if (optParaLen != 0) {
                cb.setByte(optParaLenIndex, (int)((byte)(optParaLen + 2)));
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
            message.bgpMsgHeader.setLength((short)length);
        }
    }

    static class Builder
    implements BgpOpenMsg.Builder {
        private boolean isHeaderSet = false;
        private BgpHeader bgpMsgHeader;
        private boolean isHoldTimeSet = false;
        private short holdTime;
        private boolean isAsNumSet = false;
        private short asNumber;
        private boolean isBgpIdSet = false;
        private int bgpId;
        private boolean isIpV4UnicastCapabilityTlvSet = true;
        private boolean isLargeAsCapabilityTlvSet = false;
        private boolean isLsCapabilityTlvSet = false;
        private boolean isFlowSpecCapabilityTlvSet = false;
        private boolean isVpnFlowSpecCapabilityTlvSet = false;
        LinkedList<BgpValueType> capabilityTlv = new LinkedList();

        Builder() {
        }

        @Override
        public BgpOpenMsg build() throws BgpParseException {
            BgpValueType tlv;
            short holdTime;
            BgpHeader bgpMsgHeader = this.isHeaderSet ? this.bgpMsgHeader : DEFAULT_OPEN_HEADER;
            short s = holdTime = this.isHoldTimeSet ? (short)this.holdTime : (short)120;
            if (!this.isAsNumSet) {
                throw new BgpParseException("BGP AS number is not set (mandatory)");
            }
            if (!this.isBgpIdSet) {
                throw new BgpParseException("BGPID  is not set (mandatory)");
            }
            if (this.isIpV4UnicastCapabilityTlvSet) {
                tlv = new MultiProtocolExtnCapabilityTlv(1, 0, 1);
                this.capabilityTlv.add(tlv);
            }
            if (this.isLargeAsCapabilityTlvSet) {
                short value = this.asNumber;
                tlv = new FourOctetAsNumCapabilityTlv(value);
                this.capabilityTlv.add(tlv);
            }
            if (this.isLsCapabilityTlvSet) {
                tlv = new MultiProtocolExtnCapabilityTlv(16388, 0, 71);
                this.capabilityTlv.add(tlv);
            }
            if (this.isFlowSpecCapabilityTlvSet) {
                tlv = new MultiProtocolExtnCapabilityTlv(1, 0, -123);
                this.capabilityTlv.add(tlv);
            }
            if (this.isVpnFlowSpecCapabilityTlvSet) {
                tlv = new MultiProtocolExtnCapabilityTlv(1, 0, -122);
                this.capabilityTlv.add(tlv);
            }
            return new BgpOpenMsgVer4(bgpMsgHeader, 4, this.asNumber, holdTime, this.bgpId, this.capabilityTlv);
        }

        @Override
        public Builder setHeader(BgpHeader bgpMsgHeader) {
            this.bgpMsgHeader = bgpMsgHeader;
            return this;
        }

        @Override
        public Builder setHoldTime(short holdTime) {
            this.holdTime = holdTime;
            this.isHoldTimeSet = true;
            return this;
        }

        @Override
        public Builder setAsNumber(short asNumber) {
            this.asNumber = asNumber;
            this.isAsNumSet = true;
            return this;
        }

        @Override
        public Builder setBgpId(int bgpId) {
            this.bgpId = bgpId;
            this.isBgpIdSet = true;
            return this;
        }

        @Override
        public Builder setCapabilityTlv(LinkedList<BgpValueType> capabilityTlv) {
            this.capabilityTlv = capabilityTlv;
            return this;
        }

        @Override
        public Builder setLargeAsCapabilityTlv(boolean isLargeAsCapabilitySet) {
            this.isLargeAsCapabilityTlvSet = isLargeAsCapabilitySet;
            return this;
        }

        @Override
        public Builder setLsCapabilityTlv(boolean isLsCapabilitySet) {
            this.isLsCapabilityTlvSet = isLsCapabilitySet;
            return this;
        }

        @Override
        public Builder setFlowSpecCapabilityTlv(boolean isFlowSpecCapabilitySet) {
            this.isFlowSpecCapabilityTlvSet = isFlowSpecCapabilitySet;
            return this;
        }

        @Override
        public Builder setVpnFlowSpecCapabilityTlv(boolean isVpnFlowSpecCapabilitySet) {
            this.isVpnFlowSpecCapabilityTlvSet = isVpnFlowSpecCapabilitySet;
            return this;
        }
    }

    public static class Reader
    implements BgpMessageReader<BgpOpenMsg> {
        @Override
        public BgpOpenMsg readFrom(ChannelBuffer cb, BgpHeader bgpHeader) throws BgpParseException {
            byte version;
            byte optParaLen = 0;
            byte capParaLen = 0;
            LinkedList<BgpValueType> capabilityTlv = new LinkedList<BgpValueType>();
            if (cb.readableBytes() < 10) {
                log.error("[readFrom] Invalid length: Packet size is less than the minimum length ");
                Validation.validateLen((byte)2, (byte)2, cb.readableBytes());
            }
            if ((version = cb.readByte()) != 4) {
                log.error("[readFrom] Invalid version: " + version);
                throw new BgpParseException(2, 1, null);
            }
            short asNumber = cb.readShort();
            short holdTime = cb.readShort();
            int bgpId = cb.readInt();
            optParaLen = cb.readByte();
            if (optParaLen != 0) {
                byte optParaType = cb.readByte();
                capParaLen = cb.readByte();
                if (cb.readableBytes() < capParaLen) {
                    throw new BgpParseException(2, 0, null);
                }
                ChannelBuffer capaCb = cb.readBytes((int)capParaLen);
                if (optParaType == 2 && capParaLen != 0) {
                    capabilityTlv = BgpOpenMsgVer4.parseCapabilityTlv(capaCb);
                } else {
                    throw new BgpParseException(2, 4, null);
                }
            }
            return new BgpOpenMsgVer4(bgpHeader, version, asNumber, holdTime, bgpId, capabilityTlv);
        }
    }
}

