/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpLinkAttrMaxLinkBandwidth
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpLinkAttrMaxLinkBandwidth.class);
    public static final int MAX_BANDWIDTH_LEN = 4;
    public static final int NO_OF_BITS = 8;
    public short type;
    private final float maxBandwidth;

    private BgpLinkAttrMaxLinkBandwidth(float maxBandwidth, short type) {
        this.maxBandwidth = maxBandwidth;
        this.type = type;
    }

    public static BgpLinkAttrMaxLinkBandwidth of(float maxBandwidth, short type) {
        return new BgpLinkAttrMaxLinkBandwidth(maxBandwidth, type);
    }

    public static BgpLinkAttrMaxLinkBandwidth read(ChannelBuffer cb, short type) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 4 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        float maxBandwidth = BgpLinkAttrMaxLinkBandwidth.ieeeToFloatRead(cb.readInt()) * 8.0f;
        return BgpLinkAttrMaxLinkBandwidth.of(maxBandwidth, type);
    }

    float linkAttrMaxLinkBandwidth() {
        return this.maxBandwidth;
    }

    static float ieeeToFloatRead(int iVal) {
        iVal = (iVal & 0xFF) << 24 | (iVal & 0xFF00) << 8 | (iVal & 0xFF0000) >> 8 | iVal >> 24 & 0xFF;
        return Float.intBitsToFloat(iVal);
    }

    @Override
    public short getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.maxBandwidth));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrMaxLinkBandwidth) {
            BgpLinkAttrMaxLinkBandwidth other = (BgpLinkAttrMaxLinkBandwidth)obj;
            return Objects.equals(Float.valueOf(this.maxBandwidth), Float.valueOf(other.maxBandwidth));
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("maxBandwidth", this.maxBandwidth).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

