/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkAttrMplsProtocolMask
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpLinkAttrMplsProtocolMask.class);
    public static final int ATTRLINK_MPLSPROTOMASK = 1094;
    public static final int MASK_BYTE_LEN = 1;
    private final boolean bLdp;
    private final boolean bRsvpTe;
    public static final byte FIRST_BIT = -128;
    public static final byte SECOND_BIT = 64;

    public BgpLinkAttrMplsProtocolMask(boolean bLdp, boolean bRsvpTe) {
        this.bLdp = bLdp;
        this.bRsvpTe = bRsvpTe;
    }

    public static BgpLinkAttrMplsProtocolMask of(boolean bLdp, boolean bRsvpTe) {
        return new BgpLinkAttrMplsProtocolMask(bLdp, bRsvpTe);
    }

    public static BgpLinkAttrMplsProtocolMask read(ChannelBuffer cb) throws BgpParseException {
        byte flags;
        boolean bLdp = false;
        boolean bRsvpTe = false;
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 1 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        bLdp = ((flags = cb.readByte()) & 0xFFFFFF80) == -128;
        bRsvpTe = (flags & 0x40) == 64;
        return BgpLinkAttrMplsProtocolMask.of(bLdp, bRsvpTe);
    }

    public boolean ldpBit() {
        return this.bLdp;
    }

    public boolean rsvpBit() {
        return this.bRsvpTe;
    }

    @Override
    public short getType() {
        return 1094;
    }

    public int hashCode() {
        return Objects.hash(this.bLdp, this.bRsvpTe);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrMplsProtocolMask) {
            BgpLinkAttrMplsProtocolMask other = (BgpLinkAttrMplsProtocolMask)obj;
            return Objects.equals(this.bLdp, other.bLdp) && Objects.equals(this.bRsvpTe, other.bRsvpTe);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("bLdp", this.bLdp).add("bRsvpTe", this.bRsvpTe).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

