/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkAttrUnRsrvdLinkBandwidth
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpLinkAttrUnRsrvdLinkBandwidth.class);
    public static final int MAX_BANDWIDTH_LEN = 4;
    public static final int NO_OF_BITS = 8;
    public static final int NO_OF_PRIORITY = 8;
    public short sType;
    private List<Float> maxUnResBandwidth = new ArrayList<Float>();

    public BgpLinkAttrUnRsrvdLinkBandwidth(List<Float> maxUnResBandwidth, short sType) {
        this.maxUnResBandwidth = maxUnResBandwidth;
        this.sType = sType;
    }

    public static BgpLinkAttrUnRsrvdLinkBandwidth of(List<Float> linkPfxMetric, short sType) {
        return new BgpLinkAttrUnRsrvdLinkBandwidth(linkPfxMetric, sType);
    }

    public static BgpLinkAttrUnRsrvdLinkBandwidth read(ChannelBuffer cb, short sType) throws BgpParseException {
        ArrayList<Float> maxUnResBandwidth = new ArrayList<Float>();
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 32 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        for (int i = 0; i < 8; ++i) {
            float tmp = BgpLinkAttrUnRsrvdLinkBandwidth.ieeeToFloatRead(cb.readInt()) * 8.0f;
            maxUnResBandwidth.add(new Float(tmp));
        }
        return BgpLinkAttrUnRsrvdLinkBandwidth.of(maxUnResBandwidth, sType);
    }

    public List<Float> getLinkAttrUnRsrvdLinkBandwidth() {
        return this.maxUnResBandwidth;
    }

    static float ieeeToFloatRead(int iVal) {
        iVal = (iVal & 0xFF) << 24 | (iVal & 0xFF00) << 8 | (iVal & 0xFF0000) >> 8 | iVal >> 24 & 0xFF;
        return Float.intBitsToFloat(iVal);
    }

    @Override
    public short getType() {
        return this.sType;
    }

    public int hashCode() {
        return Objects.hash(this.maxUnResBandwidth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrUnRsrvdLinkBandwidth) {
            BgpLinkAttrUnRsrvdLinkBandwidth other = (BgpLinkAttrUnRsrvdLinkBandwidth)obj;
            return Objects.equals(this.maxUnResBandwidth, other.maxUnResBandwidth);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("maxUnResBandwidth", this.maxUnResBandwidth).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

