/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPrefixAttrOspfFwdAddr
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpPrefixAttrOspfFwdAddr.class);
    public static final int ATTR_PREFIX_OSPFFWDADDR = 1156;
    public static final int IPV4_LEN = 4;
    public static final int IPV6_LEN = 16;
    private final short lsAttrLength;
    private final Ip4Address ip4RouterId;
    private final Ip6Address ip6RouterId;

    public BgpPrefixAttrOspfFwdAddr(short lsAttrLength, Ip4Address ip4RouterId, Ip6Address ip6RouterId) {
        this.lsAttrLength = lsAttrLength;
        this.ip4RouterId = ip4RouterId;
        this.ip6RouterId = ip6RouterId;
    }

    public static BgpPrefixAttrOspfFwdAddr of(short lsAttrLength, Ip4Address ip4RouterId, Ip6Address ip6RouterId) {
        return new BgpPrefixAttrOspfFwdAddr(lsAttrLength, ip4RouterId, ip6RouterId);
    }

    public static BgpPrefixAttrOspfFwdAddr read(ChannelBuffer cb) throws BgpParseException {
        Ip4Address ip4RouterId = null;
        Ip6Address ip6RouterId = null;
        short lsAttrLength = cb.readShort();
        byte[] ipBytes = new byte[lsAttrLength];
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        cb.readBytes(ipBytes);
        if (4 == lsAttrLength) {
            ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        } else if (16 == lsAttrLength) {
            ip6RouterId = Ip6Address.valueOf((byte[])ipBytes);
        }
        return BgpPrefixAttrOspfFwdAddr.of(lsAttrLength, ip4RouterId, ip6RouterId);
    }

    public Ip4Address ospfv4FwdAddr() {
        return this.ip4RouterId;
    }

    public Ip6Address ospfv6FwdAddr() {
        return this.ip6RouterId;
    }

    public short ospfFwdAddrLen() {
        return this.lsAttrLength;
    }

    @Override
    public short getType() {
        return 1156;
    }

    public int hashCode() {
        if (4 == this.lsAttrLength) {
            return Objects.hash(this.ip4RouterId);
        }
        return Objects.hash(this.ip6RouterId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixAttrOspfFwdAddr) {
            BgpPrefixAttrOspfFwdAddr other = (BgpPrefixAttrOspfFwdAddr)obj;
            if (4 == this.lsAttrLength) {
                return Objects.equals(this.ip4RouterId, other.ip4RouterId);
            }
            return Objects.equals(this.ip6RouterId, other.ip6RouterId);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        if (4 == this.lsAttrLength) {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ip4RouterId", (Object)this.ip4RouterId).toString();
        }
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ip6RouterId", (Object)this.ip6RouterId).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

