/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpPrefixLSNlri;
import org.onosproject.bgpio.protocol.BgpUpdateMsg;
import org.onosproject.bgpio.protocol.NlriType;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.protocol.ver4.BgpPathAttributes;
import org.onosproject.bgpio.types.As4Path;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.types.BgpLSIdentifierTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IPReachabilityInformationTlv;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.IsIsPseudonode;
import org.onosproject.bgpio.types.LinkStateAttributes;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.onosproject.bgpio.types.NextHop;
import org.onosproject.bgpio.types.Origin;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV4;
import org.onosproject.bgpio.types.attr.BgpLinkAttrName;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrExtRouteTag;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrIgpFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpUpdateMsgTest {
    protected static final Logger log = LoggerFactory.getLogger(BgpUpdateMsgTest.class);
    public static final byte[] MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final byte UPDATE_MSG_TYPE = 2;

    @Test
    public void bgpUpdateMessageTest01() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 2, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)23));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest02() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 2, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest03() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 24, 2, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest04() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 6, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test
    public void bgpUpdateMessageTest05() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 27, 2, 0, 4, 24, 10, 1, 1, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)27));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
        MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
        MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest06() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 27, 2, 0, 4, 25, 10, 1, 1, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test
    public void bgpUpdateMessageTest07() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 63, 2, 0, 0, 0, 28, 64, 1, 1, 0, 64, 2, 0, 64, 3, 4, 3, 3, 3, 3, -128, 4, 4, 0, 0, 0, 0, 64, 5, 4, 0, 0, 0, 100, 24, 10, 30, 3, 24, 10, 30, 2, 24, 10, 30, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)63));
        List pathAttributes = new LinkedList();
        BgpPathAttributes actualpathAttribute = other.bgpPathAttributes();
        pathAttributes = actualpathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributes.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        BgpValueType testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        List asPathValues = asPath.asPathSeq();
        MatcherAssert.assertThat((Object)asPathValues.isEmpty(), (Matcher)Is.is((Object)true));
        testPathAttribute = (BgpValueType)listIterator.next();
        NextHop nexthop = (NextHop)testPathAttribute;
        byte[] nextHopAddr = new byte[]{3, 3, 3, 3};
        MatcherAssert.assertThat((Object)nexthop.nextHop().toOctets(), (Matcher)Is.is((Object)nextHopAddr));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        LocalPref localPref = (LocalPref)testPathAttribute;
        MatcherAssert.assertThat((Object)localPref.localPref(), (Matcher)Is.is((Object)100));
        ListIterator listIterator1 = other.nlri().listIterator();
        byte[] prefix = new byte[]{10, 30, 3, 0};
        IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
        MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
        MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest08() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest09() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 4, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest10() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 26, 2, 0, 4, 24, 10, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest11() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 27, 2, 0, 4, 24, 10, 1, 1, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest12() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -1, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest13() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, -1, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest14() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -1, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest15() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 73, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest16() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 6, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest17() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, -1, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 1, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test
    public void bgpUpdateMessageTest18() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)96));
        List pathAttributes = new LinkedList();
        BgpPathAttributes actualpathAttribute = other.bgpPathAttributes();
        pathAttributes = actualpathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributes.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        BgpValueType testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = asPath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)52));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.NODE;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        BgpNodeLSNlriVer4 testNodenlri = (BgpNodeLSNlriVer4)testnlri;
        BgpNodeLSIdentifier testLocalNodeDescriptors = testNodenlri.getLocalNodeDescriptors();
        List testSubTlvs = new LinkedList();
        NodeDescriptors localNodeDescriptors = testLocalNodeDescriptors.getNodedescriptors();
        testSubTlvs = localNodeDescriptors.getSubTlvs();
        ListIterator subtlvlist1 = testSubTlvs.listIterator();
        AutonomousSystemTlv testAutonomousSystemTlv = (AutonomousSystemTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getAsNum(), (Matcher)Is.is((Object)2222));
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getType(), (Matcher)Is.is((Object)512));
        BgpLSIdentifierTlv testBgpLsIdentifierTlv = (BgpLSIdentifierTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getBgpLsIdentifier(), (Matcher)Is.is((Object)0x2020202));
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getType(), (Matcher)Is.is((Object)513));
        IsIsNonPseudonode testIsIsNonPseudonode = (IsIsNonPseudonode)subtlvlist1.next();
        byte[] expIsoNodeId = new byte[]{25, 0, -107, 1, -112, 88};
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getIsoNodeId(), (Matcher)Is.is((Object)expIsoNodeId));
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getType(), (Matcher)Is.is((Object)515));
    }

    @Test
    public void bgpUpdateMessageTest19() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -42, 2, 0, 4, 24, 10, 1, 1, 0, -69, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -112, 14, 0, -91, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 33, 104, 7, 112, 1, 1, 9, 0, 5, 32, -64, -88, 77, 1, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, 1, 9, 0, 5, 32, 21, 21, 21, 21, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 2, 32, 34, 2, 32, 34, 1, 9, 0, 5, 32, 22, 22, 22, 22};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)214));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
        MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
        MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        List pathAttributes = new LinkedList();
        BgpPathAttributes actualpathAttribute = other.bgpPathAttributes();
        pathAttributes = actualpathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributes.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        BgpValueType testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = asPath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)165));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.PREFIX_IPV4;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        BgpPrefixLSNlri testprefixnlri = (BgpPrefixLSNlri)testnlri;
        NodeDescriptors testLocalNodeDescriptors = testprefixnlri.getLocalNodeDescriptors();
        List testSubTlvs = new LinkedList();
        testSubTlvs = testLocalNodeDescriptors.getSubTlvs();
        ListIterator subtlvlist1 = testSubTlvs.listIterator();
        AutonomousSystemTlv testAutonomousSystemTlv = (AutonomousSystemTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getAsNum(), (Matcher)Is.is((Object)2222));
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getType(), (Matcher)Is.is((Object)512));
        BgpLSIdentifierTlv testBgpLsIdentifierTlv = (BgpLSIdentifierTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getBgpLsIdentifier(), (Matcher)Is.is((Object)0x2020202));
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getType(), (Matcher)Is.is((Object)513));
        IsIsNonPseudonode testIsIsNonPseudonode = (IsIsNonPseudonode)subtlvlist1.next();
        byte[] expIsoNodeId = new byte[]{25, 33, 104, 7, 112, 1};
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getIsoNodeId(), (Matcher)Is.is((Object)expIsoNodeId));
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getType(), (Matcher)Is.is((Object)515));
        List testPrefixDescriptors = new LinkedList();
        testPrefixDescriptors = testprefixnlri.getPrefixdescriptor();
        ListIterator subtlvlist2 = testPrefixDescriptors.listIterator();
        IPReachabilityInformationTlv testIPReachabilityInformationTlv = (IPReachabilityInformationTlv)subtlvlist2.next();
        byte[] address = new byte[]{-64, -88, 77, 1};
        IpPrefix prefix1 = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])address, (int)32);
        MatcherAssert.assertThat((Object)testIPReachabilityInformationTlv.getPrefixValue(), (Matcher)Is.is((Object)prefix1));
        MatcherAssert.assertThat((Object)testIPReachabilityInformationTlv.getPrefixLen(), (Matcher)Is.is((Object)32));
    }

    @Test
    public void bgpUpdateMessageTest20() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -125, 2, 0, 4, 24, 10, 1, 1, 0, 104, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)131));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
        MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
        MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        List pathAttributes = new LinkedList();
        BgpPathAttributes actualpathAttribute = other.bgpPathAttributes();
        pathAttributes = actualpathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributes.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        BgpValueType testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = asPath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        BgpLinkLsNlriVer4 testlinknlri = (BgpLinkLsNlriVer4)testnlri;
        NodeDescriptors testLocalNodeDescriptors = testlinknlri.localNodeDescriptors();
        List testSubTlvs = new LinkedList();
        testSubTlvs = testLocalNodeDescriptors.getSubTlvs();
        ListIterator subtlvlist1 = testSubTlvs.listIterator();
        AutonomousSystemTlv testAutonomousSystemTlv = (AutonomousSystemTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getAsNum(), (Matcher)Is.is((Object)2222));
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getType(), (Matcher)Is.is((Object)512));
        BgpLSIdentifierTlv testBgpLsIdentifierTlv = (BgpLSIdentifierTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getBgpLsIdentifier(), (Matcher)Is.is((Object)0x2020202));
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getType(), (Matcher)Is.is((Object)513));
        IsIsPseudonode testIsIsPseudonode = (IsIsPseudonode)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testIsIsPseudonode.getPsnIdentifier(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)testIsIsPseudonode.getType(), (Matcher)Is.is((Object)515));
        NodeDescriptors testRemoteNodeDescriptors = testlinknlri.remoteNodeDescriptors();
        testSubTlvs = testRemoteNodeDescriptors.getSubTlvs();
        ListIterator subtlvlist2 = testSubTlvs.listIterator();
        testAutonomousSystemTlv = (AutonomousSystemTlv)subtlvlist2.next();
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getAsNum(), (Matcher)Is.is((Object)2222));
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getType(), (Matcher)Is.is((Object)512));
        testBgpLsIdentifierTlv = (BgpLSIdentifierTlv)subtlvlist2.next();
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getBgpLsIdentifier(), (Matcher)Is.is((Object)0x2020202));
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getType(), (Matcher)Is.is((Object)513));
        IsIsNonPseudonode testIsIsNonPseudonode = (IsIsNonPseudonode)subtlvlist2.next();
        byte[] expIsoNodeId = new byte[]{25, 0, -107, 2, 80, 33};
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getIsoNodeId(), (Matcher)Is.is((Object)expIsoNodeId));
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getType(), (Matcher)Is.is((Object)515));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest21() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 27, 2, 0, 7, 24, 10, 1, 1, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest22() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 37, 2, 0, 0, 0, 14, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest23() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 41, 2, 0, 0, 0, 18, 14, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest24() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 41, 2, 0, 0, 0, 18, 4, 1, 2, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest25() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 41, 2, 0, 0, 0, 18, 4, 1, 1, 4, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest26() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest27() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 96, 2, 0, 0, 0, 73, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test
    public void bgpUpdateMessageTest28() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 24, 2, 0, 1, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest29() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 22, 2, 0, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test
    public void bgpUpdateMessageTest30() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 58, 2, 0, 0, 0, 33, 64, 1, 1, 0, -64, 17, 10, 2, 2, 0, 10, 0, 1, 0, 40, 0, 1, 64, 2, 6, 2, 2, 91, -96, 91, -96, 64, 3, 4, -84, 16, 3, 1, 8, 40};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)58));
        List pathAttributes = new LinkedList();
        BgpPathAttributes actualpathAttribute = other.bgpPathAttributes();
        pathAttributes = actualpathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributes.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        BgpValueType testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        As4Path as4Path = (As4Path)testPathAttribute;
        ListIterator listIterator2 = as4Path.as4PathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)655361));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        ListIterator listIterator3 = asPath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator3.next(), (Matcher)Is.is((Object)23456));
        testPathAttribute = (BgpValueType)listIterator.next();
        NextHop nextHop = (NextHop)testPathAttribute;
        byte[] nextHopAddr = new byte[]{-84, 16, 3, 1};
        MatcherAssert.assertThat((Object)nextHop.nextHop().toOctets(), (Matcher)Is.is((Object)nextHopAddr));
        ListIterator listIterator1 = other.nlri().listIterator();
        byte[] prefix = new byte[]{40, 0, 0, 0};
        IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
        MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)8));
        MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
    }

    @Test
    public void bgpUpdateMessageTest31() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 94, 2, 0, 4, 24, 10, 1, 1, 0, 67, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 15, 46, 64, 4, 71, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)MARKER));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)94));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
        MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
        MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        List pathAttributes = new LinkedList();
        BgpPathAttributes actualpathAttribute = other.bgpPathAttributes();
        pathAttributes = actualpathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributes.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        BgpValueType testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = asPath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpUnReachNlri mpUnReach = (MpUnReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpUnReach.mpUnReachNlriLen(), (Matcher)Is.is((Object)46));
        MatcherAssert.assertThat((Object)mpUnReach.getType(), (Matcher)Is.is((Object)15));
        List testMpUnReachNlri = new LinkedList();
        testMpUnReachNlri = mpUnReach.mpUnReachNlri();
        ListIterator list1 = testMpUnReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.NODE;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        BgpNodeLSNlriVer4 testNodenlri = (BgpNodeLSNlriVer4)testnlri;
        BgpNodeLSIdentifier testLocalNodeDescriptors = testNodenlri.getLocalNodeDescriptors();
        List testSubTlvs = new LinkedList();
        NodeDescriptors localNodeDescriptors = testLocalNodeDescriptors.getNodedescriptors();
        testSubTlvs = localNodeDescriptors.getSubTlvs();
        ListIterator subtlvlist1 = testSubTlvs.listIterator();
        AutonomousSystemTlv testAutonomousSystemTlv = (AutonomousSystemTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getAsNum(), (Matcher)Is.is((Object)2222));
        MatcherAssert.assertThat((Object)testAutonomousSystemTlv.getType(), (Matcher)Is.is((Object)512));
        BgpLSIdentifierTlv testBgpLsIdentifierTlv = (BgpLSIdentifierTlv)subtlvlist1.next();
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getBgpLsIdentifier(), (Matcher)Is.is((Object)0x2020202));
        MatcherAssert.assertThat((Object)testBgpLsIdentifierTlv.getType(), (Matcher)Is.is((Object)513));
        IsIsNonPseudonode testIsIsNonPseudonode = (IsIsNonPseudonode)subtlvlist1.next();
        byte[] expIsoNodeId = new byte[]{25, 0, -107, 1, -112, 88};
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getIsoNodeId(), (Matcher)Is.is((Object)expIsoNodeId));
        MatcherAssert.assertThat((Object)testIsIsNonPseudonode.getType(), (Matcher)Is.is((Object)515));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest32() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -42, 2, 0, 4, 24, 10, 1, 1, 0, -69, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -112, 14, 0, -91, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 33, 104, 7, 112, 1, 1, 9, 0, 5, 32, -64, -88, 77, 1, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, 1, 9, 0, 5, 32, 21, 21, 21, 21, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 2, 32, 34, 2, 32, 34, 1, 9, 0, 5, 32, 22, 22, 22, 22};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest33() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -42, 2, 0, 4, 24, 10, 1, 1, 0, -69, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -112, 14, 0, -91, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 3, 0, 53, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 33, 104, 7, 112, 1, 1, 9, 0, 5, 32, -64, -88, 77, 1, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, 1, 9, 0, 5, 32, 21, 21, 21, 21, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 2, 32, 34, 2, 32, 34, 1, 9, 0, 5, 32, 22, 22, 22, 22};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest34() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -125, 2, 0, 4, 24, 10, 1, 1, 0, 104, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 72, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest35() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -107, 2, 0, 4, 24, 10, 1, 1, 0, 122, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 15, 4, 4, 0, 6, -67, 89, 76, 98, 4, 71, 0, 3, 0, 0, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        reader.readFrom(buffer, bgpHeader);
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest36() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -107, 2, 0, 4, 24, 10, 1, 1, 0, 122, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 15, 4, 4, 0, 4, -67, 89, 76, 98, 4, 71, 0, 2, 0, 0, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        reader.readFrom(buffer, bgpHeader);
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest37() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -125, 0, 5, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        reader.readFrom(buffer, bgpHeader);
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest38() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -125, 0, 5, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        reader.readFrom(buffer, bgpHeader);
    }

    @Test(expected=BgpParseException.class)
    public void bgpUpdateMessageTest39() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -123, 0, 6, 10, 10, 10, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        reader.readFrom(buffer, bgpHeader);
    }

    @Test
    public void bgpUpdateMessageTest40() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -102, 2, 0, 4, 24, 10, 1, 1, 0, 127, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 20, 4, 4, 0, 4, 21, 21, 21, 21, 4, 74, 0, 8, 0, 0, 0, 10, 0, 0, 0, 11};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)154));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        byte[] linkName = new byte[]{0, 0, 0, 10, 0, 0, 0, 11};
        MatcherAssert.assertThat((Object)((BgpLinkAttrName)list.next()).attrLinkName(), (Matcher)Is.is((Object)linkName));
    }

    @Test
    public void bgpUpdateMessageTest41() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -109, 2, 0, 4, 24, 10, 1, 1, 0, 120, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 13, 4, 4, 0, 4, 21, 21, 21, 21, 4, -128, 0, 1, -96};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)147));
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        BgpPrefixAttrIgpFlags obj = new BgpPrefixAttrIgpFlags(true, false, true, false);
        MatcherAssert.assertThat((Object)((BgpPrefixAttrIgpFlags)list.next()).equals((Object)obj), (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpUpdateMessageTest42() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -94, 2, 0, 4, 24, 10, 1, 1, 0, -121, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 28, 4, 4, 0, 4, 21, 21, 21, 21, 4, -126, 0, 16, 0, 0, 0, 0, 2, -69, -23, 11, 0, 0, 0, 0, 3, 32, 110, 27};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)162));
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        LinkedList<Long> extRouteTag = new LinkedList<Long>();
        extRouteTag.add(45869323L);
        extRouteTag.add(52456987L);
        MatcherAssert.assertThat((Object)((BgpPrefixAttrExtRouteTag)list.next()).pfxExtRouteTag(), (Matcher)Is.is(extRouteTag));
    }
}

