/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.flowspec;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onosproject.bgpio.types.BgpFsDestinationPortNum;
import org.onosproject.bgpio.types.BgpFsDestinationPrefix;
import org.onosproject.bgpio.types.BgpFsDscpValue;
import org.onosproject.bgpio.types.BgpFsFragment;
import org.onosproject.bgpio.types.BgpFsIcmpCode;
import org.onosproject.bgpio.types.BgpFsIcmpType;
import org.onosproject.bgpio.types.BgpFsIpProtocol;
import org.onosproject.bgpio.types.BgpFsPacketLength;
import org.onosproject.bgpio.types.BgpFsPortNum;
import org.onosproject.bgpio.types.BgpFsSourcePortNum;
import org.onosproject.bgpio.types.BgpFsSourcePrefix;
import org.onosproject.bgpio.types.BgpFsTcpFlags;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.RouteDistinguisher;

public class BgpFlowSpecNlri {
    private List<BgpValueType> flowSpecComponents;
    private List<BgpValueType> fsActionTlv;
    private RouteDistinguisher routeDistinguisher;
    public static final short FLOW_SPEC_LEN = 240;

    public BgpFlowSpecNlri(List<BgpValueType> flowSpecComponents) {
        this.flowSpecComponents = flowSpecComponents;
    }

    public BgpFlowSpecNlri() {
    }

    public List<BgpValueType> fsActionTlv() {
        return this.fsActionTlv;
    }

    public void setFsActionTlv(List<BgpValueType> fsActionTlv) {
        this.fsActionTlv = fsActionTlv;
    }

    public RouteDistinguisher routeDistinguisher() {
        return this.routeDistinguisher;
    }

    public void setRouteDistinguiher(RouteDistinguisher routeDistinguisher) {
        this.routeDistinguisher = routeDistinguisher;
    }

    public List<BgpValueType> flowSpecComponents() {
        return this.flowSpecComponents;
    }

    public void setFlowSpecComponents(List<BgpValueType> flowSpecComponents) {
        this.flowSpecComponents = flowSpecComponents;
    }

    public int hashCode() {
        return Objects.hash(this.flowSpecComponents);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFlowSpecNlri) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            BgpFlowSpecNlri other = (BgpFlowSpecNlri)obj;
            Iterator<BgpValueType> objListIterator = other.flowSpecComponents.iterator();
            countOtherSubTlv = other.flowSpecComponents.size();
            countObjSubTlv = this.flowSpecComponents.size();
            if (countObjSubTlv != countOtherSubTlv) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                BgpValueType subTlv = objListIterator.next();
                if (this.flowSpecComponents.contains(subTlv) && other.flowSpecComponents.contains(subTlv)) {
                    isCommonSubTlv = Objects.equals(this.flowSpecComponents.get(this.flowSpecComponents.indexOf(subTlv)), other.flowSpecComponents.get(other.flowSpecComponents.indexOf(subTlv)));
                    continue;
                }
                isCommonSubTlv = false;
            }
            return isCommonSubTlv;
        }
        return false;
    }

    public static void writeFlowType(BgpValueType tlv, ChannelBuffer cb) {
        switch (tlv.getType()) {
            case 1: {
                BgpFsDestinationPrefix fsDstPrefix = (BgpFsDestinationPrefix)tlv;
                fsDstPrefix.write(cb);
                break;
            }
            case 2: {
                BgpFsSourcePrefix fsSrcPrefix = (BgpFsSourcePrefix)tlv;
                fsSrcPrefix.write(cb);
                break;
            }
            case 3: {
                BgpFsIpProtocol fsIpProtocol = (BgpFsIpProtocol)tlv;
                fsIpProtocol.write(cb);
                break;
            }
            case 4: {
                BgpFsPortNum fsPortNum = (BgpFsPortNum)tlv;
                fsPortNum.write(cb);
                break;
            }
            case 5: {
                BgpFsDestinationPortNum fsDstPortNum = (BgpFsDestinationPortNum)tlv;
                fsDstPortNum.write(cb);
                break;
            }
            case 6: {
                BgpFsSourcePortNum fsSrcPortNum = (BgpFsSourcePortNum)tlv;
                fsSrcPortNum.write(cb);
                break;
            }
            case 7: {
                BgpFsIcmpType fsIcmpType = (BgpFsIcmpType)tlv;
                fsIcmpType.write(cb);
                break;
            }
            case 8: {
                BgpFsIcmpCode fsIcmpCode = (BgpFsIcmpCode)tlv;
                fsIcmpCode.write(cb);
                break;
            }
            case 9: {
                BgpFsTcpFlags fsTcpFlags = (BgpFsTcpFlags)tlv;
                fsTcpFlags.write(cb);
                break;
            }
            case 10: {
                BgpFsPacketLength fsPacketLen = (BgpFsPacketLength)tlv;
                fsPacketLen.write(cb);
                break;
            }
            case 11: {
                BgpFsDscpValue fsDscpVal = (BgpFsDscpValue)tlv;
                fsDscpVal.write(cb);
                break;
            }
            case 12: {
                BgpFsFragment fsFragment = (BgpFsFragment)tlv;
                fsFragment.write(cb);
                break;
            }
        }
    }

    public static void updateBufferIdenticalFlowTypes(ChannelBuffer cb, BgpFlowSpecNlri bgpFlowSpecNlri) {
        List<BgpValueType> flowSpec = bgpFlowSpecNlri.flowSpecComponents();
        ListIterator<BgpValueType> listIterator = flowSpec.listIterator();
        while (listIterator.hasNext()) {
            ChannelBuffer flowSpecTmpBuff = ChannelBuffers.dynamicBuffer();
            int tmpBuffStartIndx = flowSpecTmpBuff.writerIndex();
            BgpValueType tlv = listIterator.next();
            BgpFlowSpecNlri.writeFlowType(tlv, flowSpecTmpBuff);
            int len = flowSpecTmpBuff.writerIndex() - tmpBuffStartIndx;
            if (len >= 240) {
                cb.writeShort(len);
            } else {
                cb.writeByte(len);
            }
            cb.writeBytes(flowSpecTmpBuff);
        }
    }

    public static void updateBufferNonIdenticalFlowTypes(ChannelBuffer cb, BgpFlowSpecNlri bgpFlowSpecNlri) {
        ChannelBuffer flowSpecTmpBuff = ChannelBuffers.dynamicBuffer();
        List<BgpValueType> flowSpec = bgpFlowSpecNlri.flowSpecComponents();
        ListIterator<BgpValueType> listIterator = flowSpec.listIterator();
        int tmpBuffStartIndx = flowSpecTmpBuff.writerIndex();
        flowSpec = bgpFlowSpecNlri.flowSpecComponents();
        listIterator = flowSpec.listIterator();
        while (listIterator.hasNext()) {
            BgpValueType tlv = listIterator.next();
            BgpFlowSpecNlri.writeFlowType(tlv, flowSpecTmpBuff);
        }
        int len = flowSpecTmpBuff.writerIndex() - tmpBuffStartIndx;
        if (len >= 240) {
            cb.writeShort(len);
        } else {
            cb.writeByte(len);
        }
        cb.writeBytes(flowSpecTmpBuff);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("flowSpecComponents", this.flowSpecComponents).toString();
    }
}

