/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.protocol.IgpRouterId;
import org.onosproject.bgpio.types.BgpValueType;

public class IsIsPseudonode
implements IgpRouterId,
BgpValueType {
    public static final short TYPE = 515;
    public static final short LENGTH = 7;
    private final byte[] isoNodeID;
    private byte psnIdentifier;

    public IsIsPseudonode(byte[] isoNodeID, byte psnIdentifier) {
        this.isoNodeID = Arrays.copyOf(isoNodeID, isoNodeID.length);
        this.psnIdentifier = psnIdentifier;
    }

    public static IsIsPseudonode of(byte[] isoNodeID, byte psnIdentifier) {
        return new IsIsPseudonode(isoNodeID, psnIdentifier);
    }

    public byte[] getIsoNodeId() {
        return this.isoNodeID;
    }

    public byte getPsnIdentifier() {
        return this.psnIdentifier;
    }

    public int hashCode() {
        return Arrays.hashCode(this.isoNodeID) & Objects.hash(this.psnIdentifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IsIsPseudonode) {
            IsIsPseudonode other = (IsIsPseudonode)obj;
            return Arrays.equals(this.isoNodeID, other.isoNodeID) && Objects.equals(this.psnIdentifier, other.psnIdentifier);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(515);
        c.writeShort(7);
        c.writeBytes(this.isoNodeID, 0, 6);
        c.writeByte((int)this.psnIdentifier);
        return c.writerIndex() - iLenStartIndex;
    }

    public static IsIsPseudonode read(ChannelBuffer cb) {
        byte[] isoNodeID = new byte[6];
        cb.readBytes(isoNodeID);
        byte psnIdentifier = cb.readByte();
        return IsIsPseudonode.of(isoNodeID, psnIdentifier);
    }

    @Override
    public short getType() {
        return 515;
    }

    @Override
    public int compareTo(Object o) {
        ByteBuffer value2;
        if (this.equals(o)) {
            return 0;
        }
        ByteBuffer value1 = ByteBuffer.wrap(this.isoNodeID);
        if (value1.compareTo(value2 = ByteBuffer.wrap(((IsIsPseudonode)o).isoNodeID)) != 0) {
            return value1.compareTo(value2);
        }
        return Byte.valueOf(this.psnIdentifier).compareTo(((IsIsPseudonode)o).psnIdentifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 515).add("Length", 7).add("isoNodeID", (Object)this.isoNodeID).add("psnIdentifier", (int)this.psnIdentifier).toString();
    }
}

