/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPrefixAttrMetric
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpPrefixAttrMetric.class);
    public static final int ATTR_PREFIX_METRIC = 1155;
    public static final int ATTR_PREFIX_LEN = 4;
    private final int linkPfxMetric;

    public BgpPrefixAttrMetric(int linkPfxMetric) {
        this.linkPfxMetric = linkPfxMetric;
    }

    public static BgpPrefixAttrMetric of(int linkPfxMetric) {
        return new BgpPrefixAttrMetric(linkPfxMetric);
    }

    public static BgpPrefixAttrMetric read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 4 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        int linkPfxMetric = cb.readInt();
        return BgpPrefixAttrMetric.of(linkPfxMetric);
    }

    public int attrPfxMetric() {
        return this.linkPfxMetric;
    }

    @Override
    public short getType() {
        return 1155;
    }

    public int hashCode() {
        return Objects.hash(this.linkPfxMetric);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixAttrMetric) {
            BgpPrefixAttrMetric other = (BgpPrefixAttrMetric)obj;
            return Objects.equals(this.linkPfxMetric, other.linkPfxMetric);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("linkPfxMetric", this.linkPfxMetric).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

