/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.util;

import com.google.common.primitives.Ints;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validation {
    private static final Logger log = LoggerFactory.getLogger(Validation.class);
    public static final byte FIRST_BIT = -128;
    public static final byte SECOND_BIT = 64;
    public static final byte THIRD_BIT = 32;
    public static final byte FOURTH_BIT = 16;
    public static final byte IPV4_SIZE = 4;
    private boolean firstBit;
    private boolean secondBit;
    private boolean thirdBit;
    private boolean fourthBit;
    private int len;
    private boolean isShort;

    Validation(boolean firstBit, boolean secondBit, boolean thirdBit, boolean fourthBit, int len, boolean isShort) {
        this.firstBit = firstBit;
        this.secondBit = secondBit;
        this.thirdBit = thirdBit;
        this.fourthBit = fourthBit;
        this.len = len;
        this.isShort = isShort;
    }

    public static Validation parseAttributeHeader(ChannelBuffer cb) {
        short len;
        boolean isShort;
        boolean fourthBit;
        byte flags = cb.readByte();
        byte typeCode = cb.readByte();
        byte temp = flags;
        boolean firstBit = (temp & 0xFFFFFF80) == -128;
        boolean secondBit = (temp & 0x40) == 64;
        boolean thirdBit = (temp & 0x20) == 32;
        boolean bl = fourthBit = (temp & 0x10) == 16;
        if (fourthBit) {
            short length;
            isShort = true;
            len = length = cb.readShort();
        } else {
            isShort = false;
            byte length = cb.readByte();
            len = length;
        }
        return new Validation(firstBit, secondBit, thirdBit, fourthBit, len, isShort);
    }

    public static void validateLen(byte errorCode, byte subErrCode, int length) throws BgpParseException {
        byte[] errLen = Ints.toByteArray((int)length);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(errLen);
        throw new BgpParseException(errorCode, subErrCode, buffer);
    }

    public static void validateType(byte errorCode, byte subErrCode, int type) throws BgpParseException {
        byte[] errType = Ints.toByteArray((int)type);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(errType);
        throw new BgpParseException(errorCode, subErrCode, buffer);
    }

    public static InetAddress toInetAddress(int length, ChannelBuffer cb) {
        byte[] address = new byte[length];
        cb.readBytes(address, 0, length);
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            log.info("InetAddress convertion failed");
        }
        return ipAddress;
    }

    public boolean getFirstBit() {
        return this.firstBit;
    }

    public boolean getSecondBit() {
        return this.secondBit;
    }

    public boolean getThirdBit() {
        return this.thirdBit;
    }

    public boolean getFourthBit() {
        return this.fourthBit;
    }

    public int getLength() {
        return this.len;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public static IpPrefix bytesToPrefix(byte[] value, int length) {
        if (value.length != 4) {
            value = Arrays.copyOf(value, 4);
        }
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)length);
        return ipPrefix;
    }
}

