/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.checkstyle;

import com.google.common.io.ByteStreams;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onosproject.checkstyle.StringAuditor;

public class CheckstyleRunner {
    private final Configuration config;

    public CheckstyleRunner(String configLocation, String suppressionLocation) throws CheckstyleException {
        DefaultConfiguration config = (DefaultConfiguration)ConfigurationLoader.loadConfiguration((String)configLocation, (PropertyResolver)new PropertiesExpander(System.getProperties()));
        DefaultConfiguration suppressions = new DefaultConfiguration("SuppressionFilter");
        suppressions.addAttribute("file", suppressionLocation);
        config.addChild((Configuration)suppressions);
        this.config = config;
    }

    public Runnable checkClass(Socket socket) {
        return () -> {
            try {
                String input = new String(ByteStreams.toByteArray((InputStream)socket.getInputStream()));
                String output = this.checkClass(input);
                socket.getOutputStream().write(output.getBytes());
                socket.getOutputStream().flush();
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CheckstyleException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkClass(String input) throws CheckstyleException, InterruptedException {
        String[] split = input.split("\n", 3);
        if (split.length < 3 || split[2].length() == 0) {
            return "";
        }
        String project = split[0];
        String baseDir = split[1];
        String files = split[2];
        StringAuditor listener = new StringAuditor();
        listener.setProjectName(project);
        listener.setBaseDir(baseDir);
        Checker checker = new Checker();
        ClassLoader moduleClassLoader = Checker.class.getClassLoader();
        checker.setModuleClassLoader(moduleClassLoader);
        try {
            checker.configure(this.config);
            checker.addListener((AuditListener)listener);
            List fileList = Stream.of(files.split("\n")).map(File::new).collect(Collectors.toList());
            int errorCounter = checker.process(fileList);
            if (errorCounter > 0) {
                listener.append("CHECKSTYLE ERROR\n");
            }
        }
        finally {
            checker.destroy();
        }
        return listener.getAudit();
    }
}

