/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onosproject.checkstyle.CheckstyleRunner;

public final class Main {
    private static long POLLING_INTERVAL = 1000L;

    private Main(String[] args) {
    }

    public static void main(String[] args) throws CheckstyleException, IOException {
        Main.startServer(args);
    }

    private static void watchProcess(final String pid) {
        if (pid == null || pid.equals("0")) {
            return;
        }
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){
            private String cmd;
            {
                this.cmd = "kill -s 0 " + pid;
            }

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec(this.cmd);
                    p.waitFor();
                    if (p.exitValue() != 0) {
                        System.err.println("shutting down...");
                        System.exit(0);
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, POLLING_INTERVAL, POLLING_INTERVAL);
    }

    private static void startServer(String[] args) throws IOException, CheckstyleException {
        String portLock = args[0];
        String buckPid = args[1];
        String checkstyleFile = args[2];
        String suppressionsFile = args[3];
        Path portLockPath = Paths.get(portLock, new String[0]);
        FileChannel channel = FileChannel.open(portLockPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        FileLock lock = channel.tryLock();
        if (lock == null) {
            System.out.println("Server is already running");
            System.exit(1);
        }
        ServerSocket server = new ServerSocket(0);
        Main.watchProcess(buckPid);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (channel != null) {
                    channel.truncate(0L);
                    channel.close();
                }
                System.err.println("tear down...");
                Files.delete(portLockPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        int port = server.getLocalPort();
        channel.truncate(0L);
        channel.write(ByteBuffer.wrap(Integer.toString(port).getBytes()));
        CheckstyleRunner runner = new CheckstyleRunner(checkstyleFile, suppressionsFile);
        ExecutorService executor = Executors.newCachedThreadPool();
        while (true) {
            try {
                while (true) {
                    executor.submit(runner.checkClass(server.accept()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

