/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.checkstyle;

import com.google.common.base.Strings;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import java.util.concurrent.CountDownLatch;

class StringAuditor
implements AuditListener {
    private CountDownLatch finishedLatch = new CountDownLatch(1);
    private StringBuilder output = new StringBuilder();
    private String baseDir = "";
    private String project = "";

    StringAuditor() {
    }

    public void setBaseDir(String base) {
        this.baseDir = base;
    }

    public void setProjectName(String projectName) {
        this.project = projectName;
    }

    public void append(String s) {
        this.output.append(s);
    }

    public String getAudit() throws InterruptedException {
        this.finishedLatch.await();
        return this.output.toString();
    }

    public void auditStarted(AuditEvent evt) {
    }

    public void auditFinished(AuditEvent evt) {
        this.finishedLatch.countDown();
    }

    public void fileStarted(AuditEvent evt) {
    }

    public void fileFinished(AuditEvent evt) {
    }

    public void addError(AuditEvent evt) {
        switch (evt.getSeverityLevel()) {
            case ERROR: {
                int index;
                String fileName = evt.getFileName();
                if (!Strings.isNullOrEmpty((String)this.baseDir) && (index = fileName.indexOf(this.baseDir)) >= 0) {
                    fileName = fileName.substring(index + this.baseDir.length() + 1);
                    if (!Strings.isNullOrEmpty((String)this.project)) {
                        this.output.append(this.project).append(':');
                    }
                }
                this.output.append(fileName).append(':').append(evt.getLine());
                if (evt.getColumn() > 0) {
                    this.output.append(':').append(evt.getColumn());
                }
                this.output.append(": ").append(evt.getMessage());
                this.output.append('\n');
                break;
            }
        }
    }

    public void addException(AuditEvent evt, Throwable throwable) {
        this.addError(evt);
        this.output.append(throwable.getMessage());
    }
}

