/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.CoreService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;

@Command(scope="onos", name="summary", description="Provides summary of ONOS model")
public class SummaryCommand
extends AbstractShellCommand {
    @Override
    protected void execute() {
        TopologyService topologyService = SummaryCommand.get(TopologyService.class);
        Topology topology = topologyService.currentTopology();
        if (this.outputJson()) {
            this.print("%s", new ObjectMapper().createObjectNode().put("node", SummaryCommand.get(ClusterService.class).getLocalNode().ip().toString()).put("version", SummaryCommand.get(CoreService.class).version().toString()).put("nodes", SummaryCommand.get(ClusterService.class).getNodes().size()).put("devices", topology.deviceCount()).put("links", topology.linkCount()).put("hosts", SummaryCommand.get(HostService.class).getHostCount()).put("SCC(s)", topology.clusterCount()).put("paths", topology.pathCount()).put("flows", SummaryCommand.get(FlowRuleService.class).getFlowRuleCount()).put("intents", SummaryCommand.get(IntentService.class).getIntentCount()));
        } else {
            this.print("node=%s, version=%s", SummaryCommand.get(ClusterService.class).getLocalNode().ip(), SummaryCommand.get(CoreService.class).version().toString());
            this.print("nodes=%d, devices=%d, links=%d, hosts=%d, SCC(s)=%s, paths=%d, flows=%d, intents=%d", SummaryCommand.get(ClusterService.class).getNodes().size(), SummaryCommand.get(DeviceService.class).getDeviceCount(), SummaryCommand.get(LinkService.class).getLinkCount(), SummaryCommand.get(HostService.class).getHostCount(), topologyService.getClusters(topology).size(), topology.pathCount(), SummaryCommand.get(FlowRuleService.class).getFlowRuleCount(), SummaryCommand.get(IntentService.class).getIntentCount());
        }
    }
}

