/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.store.service.DatabaseAdminService;

@Command(scope="onos", name="tablet-member", description="Lists all member nodes")
public class TabletMemberCommand
extends AbstractShellCommand {
    @Override
    protected void execute() {
        DatabaseAdminService service = TabletMemberCommand.get(DatabaseAdminService.class);
        ClusterService clusterService = TabletMemberCommand.get(ClusterService.class);
        ArrayList nodes = Lists.newArrayList((Iterable)service.listMembers());
        Collections.sort(nodes, Comparators.NODE_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(service, nodes));
        } else {
            ControllerNode self = clusterService.getLocalNode();
            for (ControllerNode node : nodes) {
                this.print("id=%s, address=%s:%s %s", node.id(), node.ip(), node.tcpPort(), node.equals(self) ? "*" : "");
            }
        }
    }

    private JsonNode json(DatabaseAdminService service, List<ControllerNode> nodes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (ControllerNode node : nodes) {
            result.add((JsonNode)mapper.createObjectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("tcpPort", node.tcpPort()));
        }
        return result;
    }
}

