/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.OpticalConnectivityIntent;

@Command(scope="onos", name="add-optical-intent", description="Installs optical connectivity intent")
public class AddOpticalIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressDeviceString = null;
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressDeviceString = null;

    @Override
    protected void execute() {
        IntentService service = AddOpticalIntentCommand.get(IntentService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.ingressDeviceString));
        ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        DeviceId egressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        OpticalConnectivityIntent intent = new OpticalConnectivityIntent(this.appId(), ingress, egress);
        service.submit((Intent)intent);
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

