/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentOperations;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.PointToPointIntent;

@Command(scope="onos", name="push-test-intents", description="Installs random intents to test throughput")
public class IntentPushTestCommand
extends AbstractShellCommand
implements IntentListener {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressDeviceString = null;
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressDeviceString = null;
    @Argument(index=2, name="IntentsPerAppId", description="Number of intents per appId", required=true, multiValued=false)
    String intentsPerAppId = null;
    @Argument(index=3, name="apps", description="Number of appIds", required=false, multiValued=false)
    String appIds = null;
    @Argument(index=4, name="appIdBase", description="Base Value for Application IDs", required=false, multiValued=false)
    String appIdBaseStr = null;
    @Option(name="-i", aliases={"--install"}, description="Install intents", required=false, multiValued=false)
    private boolean installOnly = false;
    @Option(name="-w", aliases={"--withdraw"}, description="Withdraw intents", required=false, multiValued=false)
    private boolean withdrawOnly = false;
    private IntentService service;
    private CountDownLatch latch;
    private volatile long start;
    private volatile long end;
    private int apps;
    private int intentsPerApp;
    private int appIdBase;
    private int count;
    private boolean add;
    private final Set<ApplicationId> myAppIds = new HashSet<ApplicationId>();
    private static final EnumSet<IntentEvent.Type> IGNORE_EVENT = EnumSet.of(IntentEvent.Type.INSTALL_REQ, IntentEvent.Type.WITHDRAW_REQ);

    @Override
    protected void execute() {
        boolean both;
        this.service = IntentPushTestCommand.get(IntentService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.ingressDeviceString));
        ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        DeviceId egressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        this.apps = this.appIds != null ? Integer.parseInt(this.appIds) : 1;
        this.intentsPerApp = Integer.parseInt(this.intentsPerAppId);
        this.appIdBase = this.appIdBaseStr != null ? Integer.parseInt(this.appIdBaseStr) : 1;
        this.count = this.intentsPerApp * this.apps;
        this.service.addListener((IntentListener)this);
        ArrayListMultimap<Integer, Intent> operations = this.generateIntents(ingress, egress);
        boolean bl = both = !(this.installOnly ^ this.withdrawOnly);
        if (this.installOnly || both) {
            this.add = true;
            this.latch = new CountDownLatch(this.count);
            this.submitIntents(operations);
        }
        if (this.withdrawOnly || both) {
            if (this.withdrawOnly && !both) {
                this.print("This should fail for now...", new Object[0]);
            }
            this.add = false;
            this.latch = new CountDownLatch(this.count);
            this.submitIntents(operations);
        }
        this.service.removeListener((IntentListener)this);
    }

    private ArrayListMultimap<Integer, Intent> generateIntents(ConnectPoint ingress, ConnectPoint egress) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder().matchEthType((short)2048);
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        ArrayListMultimap intents = ArrayListMultimap.create();
        for (int app = 0; app < this.apps; ++app) {
            for (int i = 1; i <= this.intentsPerApp; ++i) {
                TrafficSelector s = selector.matchEthSrc(MacAddress.valueOf((long)(i + (app + this.appIdBase) * this.intentsPerApp))).build();
                intents.put((Object)app, (Object)new PointToPointIntent(this.appId(app), s, treatment, ingress, egress));
            }
        }
        return intents;
    }

    private void submitIntents(ArrayListMultimap<Integer, Intent> intents) {
        ArrayList opList = Lists.newArrayList();
        for (Integer app : intents.keySet()) {
            IntentOperations.Builder builder = IntentOperations.builder((ApplicationId)this.appId(app));
            for (Intent intent : intents.get((Object)app)) {
                if (this.add) {
                    builder.addSubmitOperation(intent);
                    continue;
                }
                builder.addWithdrawOperation(intent.id());
            }
            opList.add(builder.build());
        }
        this.start = System.currentTimeMillis();
        opList.forEach(ops -> this.service.execute(ops));
        try {
            if (this.latch.await(100 + this.count * 200, TimeUnit.MILLISECONDS)) {
                this.printResults(this.count);
            } else {
                this.print("Failure: %d intents not installed", this.latch.getCount());
            }
        }
        catch (InterruptedException e) {
            this.print(e.toString(), new Object[0]);
        }
    }

    private void printResults(int count) {
        long delta = this.end - this.start;
        String text = this.add ? "install" : "withdraw";
        this.print("Time to %s %d intents: %d ms", text, count, delta);
    }

    protected ApplicationId appId(Integer id) {
        ApplicationId appId = IntentPushTestCommand.get(CoreService.class).registerApplication("org.onosproject.cli-" + (id + this.appIdBase));
        this.myAppIds.add(appId);
        return appId;
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }

    public synchronized void event(IntentEvent event) {
        IntentEvent.Type expected;
        if (!this.myAppIds.contains(((Intent)event.subject()).appId())) {
            return;
        }
        IntentEvent.Type type = expected = this.add ? IntentEvent.Type.INSTALLED : IntentEvent.Type.WITHDRAWN;
        if (event.type() == expected) {
            this.end = Math.max(this.end, event.time());
            if (this.latch != null) {
                if (this.latch.getCount() == 0L) {
                    this.log.warn("Latch was already 0 before counting down?");
                }
                this.latch.countDown();
            } else {
                this.log.warn("install event latch is null");
            }
        } else if (IGNORE_EVENT.contains(event.type())) {
            this.log.info("Unexpected intent event: {}", (Object)event);
        }
    }
}

