/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyProvider;
import org.onosproject.net.topology.TopologyService;

@Command(scope="onos", name="topology", description="Lists summary of the current topology")
public class TopologyCommand
extends AbstractShellCommand {
    private static final String FMT = "time=%s, devices=%d, links=%d, clusters=%d, paths=%d";
    @Option(name="-r", aliases={"--recompute"}, description="Trigger topology re-computation", required=false, multiValued=false)
    private boolean recompute = false;
    protected TopologyService service;
    protected Topology topology;

    protected void init() {
        this.service = TopologyCommand.get(TopologyService.class);
        this.topology = this.service.currentTopology();
    }

    @Override
    protected void execute() {
        this.init();
        if (this.recompute) {
            TopologyCommand.get(TopologyProvider.class).triggerRecompute();
        } else if (this.outputJson()) {
            this.print("%s", new ObjectMapper().createObjectNode().put("time", this.topology.time()).put("deviceCount", this.topology.deviceCount()).put("linkCount", this.topology.linkCount()).put("clusterCount", this.topology.clusterCount()).put("pathCount", this.topology.pathCount()));
        } else {
            this.print(FMT, this.topology.time(), this.topology.deviceCount(), this.topology.linkCount(), this.topology.clusterCount(), this.topology.pathCount());
        }
    }
}

