/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;

@Command(scope="onos", name="apps", description="Lists application ID information")
public class ApplicationIdListCommand
extends AbstractShellCommand {
    @Override
    protected void execute() {
        CoreService service = ApplicationIdListCommand.get(CoreService.class);
        ArrayList ids = Lists.newArrayList((Iterable)service.getAppIds());
        Collections.sort(ids, Comparators.APP_ID_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(ids));
        } else {
            for (ApplicationId id : ids) {
                this.print("id=%d, name=%s", id.id(), id.name());
            }
        }
    }

    private JsonNode json(List<ApplicationId> ids) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (ApplicationId id : ids) {
            result.add((JsonNode)mapper.createObjectNode().put("id", id.id()).put("name", id.name()));
        }
        return result;
    }
}

