/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Device;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

@Command(scope="onos", name="add-flows", description="Installs a flow rules")
public class AddFlowsCommand
extends AbstractShellCommand {
    @Argument(index=0, name="flowPerDevice", description="Number of flows to add per device", required=true, multiValued=false)
    String flows = null;
    @Argument(index=1, name="numOfRuns", description="Number of iterations", required=true, multiValued=false)
    String numOfRuns = null;

    @Override
    protected void execute() {
        FlowRuleService flowService = AddFlowsCommand.get(FlowRuleService.class);
        DeviceService deviceService = AddFlowsCommand.get(DeviceService.class);
        int flowsPerDevice = Integer.parseInt(this.flows);
        int num = Integer.parseInt(this.numOfRuns);
        ArrayList results = Lists.newArrayList();
        Iterable devices = deviceService.getDevices();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)1L)).build();
        HashSet rules = Sets.newHashSet();
        HashSet remove = Sets.newHashSet();
        for (Device d : devices) {
            for (int i = 0; i < flowsPerDevice; ++i) {
                TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
                sbuilder.matchEthSrc(MacAddress.valueOf((long)i)).matchEthDst(MacAddress.valueOf((long)(Integer.MAX_VALUE - i)));
                rules.add(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, (FlowRule)new DefaultFlowRule(d.id(), sbuilder.build(), treatment, 100, 0L, 10, false)));
                remove.add(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, (FlowRule)new DefaultFlowRule(d.id(), sbuilder.build(), treatment, 100, 0L, 10, false)));
            }
        }
        boolean isSuccess = true;
        for (int i = 0; i < num; ++i) {
            long startTime = System.currentTimeMillis();
            Future op = flowService.applyBatch(new FlowRuleBatchOperation((Collection)rules));
            try {
                isSuccess &= ((CompletedBatchOperation)op.get()).isSuccess();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            results.add(endTime - startTime);
            flowService.applyBatch(new FlowRuleBatchOperation((Collection)remove));
        }
        if (this.outputJson()) {
            this.print("%s", this.json(new ObjectMapper(), isSuccess, results));
        } else {
            this.printTime(isSuccess, results);
        }
    }

    private Object json(ObjectMapper mapper, boolean isSuccess, ArrayList<Long> elapsed) {
        ObjectNode result = mapper.createObjectNode();
        result.put("Success", isSuccess);
        ArrayNode node = result.putArray("elapsed-time");
        for (Long v : elapsed) {
            node.add(v);
        }
        return result;
    }

    private void printTime(boolean isSuccess, ArrayList<Long> elapsed) {
        this.print("Run is %s.", isSuccess ? "success" : "failure");
        for (int i = 0; i < elapsed.size(); ++i) {
            this.print("  Run %s : %s", i, elapsed.get(i));
        }
    }
}

