/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.net.Device;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="devices", description="Lists all infrastructure devices")
public class DevicesListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, available=%s, role=%s, type=%s, mfr=%s, hw=%s, sw=%s, serial=%s%s";

    @Override
    protected void execute() {
        DeviceService service = DevicesListCommand.get(DeviceService.class);
        if (this.outputJson()) {
            this.print("%s", DevicesListCommand.json(service, DevicesListCommand.getSortedDevices(service)));
        } else {
            for (Device device : DevicesListCommand.getSortedDevices(service)) {
                this.printDevice(service, device);
            }
        }
    }

    public static JsonNode json(DeviceService service, Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)DevicesListCommand.json(service, mapper, device));
        }
        return result;
    }

    public static ObjectNode json(DeviceService service, ObjectMapper mapper, Device device) {
        ObjectNode result = mapper.createObjectNode();
        if (device != null) {
            result.put("id", device.id().toString()).put("available", service.isAvailable(device.id())).put("type", device.type().toString()).put("role", service.getRole(device.id()).toString()).put("mfr", device.manufacturer()).put("hw", device.hwVersion()).put("sw", device.swVersion()).put("serial", device.serialNumber()).set("annotations", (JsonNode)DevicesListCommand.annotations(mapper, device.annotations()));
        }
        return result;
    }

    public static List<Device> getSortedDevices(DeviceService service) {
        ArrayList devices = Lists.newArrayList((Iterable)service.getDevices());
        Collections.sort(devices, Comparators.ELEMENT_COMPARATOR);
        return devices;
    }

    protected void printDevice(DeviceService service, Device device) {
        if (device != null) {
            this.print(FMT, device.id(), service.isAvailable(device.id()), service.getRole(device.id()), device.type(), device.manufacturer(), device.hwVersion(), device.swVersion(), device.serialNumber(), DevicesListCommand.annotations(device.annotations()));
        }
    }
}

