/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.cli.net.LinksListCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostService;

@Command(scope="onos", name="hosts", description="Lists all currently-known hosts.")
public class HostsListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, mac=%s, location=%s/%s, vlan=%s, ip(s)=%s%s";

    @Override
    protected void execute() {
        HostService service = HostsListCommand.get(HostService.class);
        if (this.outputJson()) {
            this.print("%s", HostsListCommand.json(this.getSortedHosts(service)));
        } else {
            for (Host host : this.getSortedHosts(service)) {
                this.printHost(host);
            }
        }
    }

    private static JsonNode json(Iterable<Host> hosts) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Host host : hosts) {
            result.add(HostsListCommand.json(mapper, host));
        }
        return result;
    }

    private static JsonNode json(ObjectMapper mapper, Host host) {
        ObjectNode loc = LinksListCommand.json(mapper, (ConnectPoint)host.location()).put("time", host.location().time());
        ArrayNode ips = mapper.createArrayNode();
        for (IpAddress ip : host.ipAddresses()) {
            ips.add(ip.toString());
        }
        ObjectNode result = mapper.createObjectNode().put("id", host.id().toString()).put("mac", host.mac().toString()).put("vlan", host.vlan().toString());
        result.set("location", (JsonNode)loc);
        result.set("ips", (JsonNode)ips);
        result.set("annotations", (JsonNode)HostsListCommand.annotations(mapper, host.annotations()));
        return result;
    }

    protected List<Host> getSortedHosts(HostService service) {
        ArrayList hosts = Lists.newArrayList((Iterable)service.getHosts());
        Collections.sort(hosts, Comparators.ELEMENT_COMPARATOR);
        return hosts;
    }

    protected void printHost(Host host) {
        if (host != null) {
            this.print(FMT, host.id(), host.mac(), host.location().deviceId(), host.location().port(), host.vlan(), host.ipAddresses(), HostsListCommand.annotations(host.annotations()));
        }
    }
}

