/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentOperations;
import org.onosproject.net.intent.IntentService;

@Command(scope="onos", name="push-random-intents", description="Installs random intents to test throughput")
public class RandomIntentCommand
extends AbstractShellCommand {
    @Argument(index=0, name="count", description="Number of intents to push", required=true, multiValued=false)
    String countString = null;
    private IntentService service;
    private HostService hostService;
    private int count;

    @Override
    protected void execute() {
        this.service = RandomIntentCommand.get(IntentService.class);
        this.hostService = RandomIntentCommand.get(HostService.class);
        this.count = Integer.parseInt(this.countString);
        if (this.count > 0) {
            Collection<Intent> intents = this.generateIntents();
            this.submitIntents(intents);
        } else {
            this.withdrawIntents();
        }
    }

    private Collection<Intent> generateIntents() {
        TrafficSelector selector = DefaultTrafficSelector.builder().build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        ArrayList hosts = Lists.newArrayList((Iterable)this.hostService.getHosts());
        ArrayList fullMesh = Lists.newArrayList();
        for (int i = 0; i < hosts.size(); ++i) {
            for (int j = i + 1; j < hosts.size(); ++j) {
                fullMesh.add(new HostToHostIntent(this.appId(), ((Host)hosts.get(i)).id(), ((Host)hosts.get(j)).id(), selector, treatment));
            }
        }
        Collections.shuffle(fullMesh);
        return fullMesh.subList(0, Math.min(this.count, fullMesh.size()));
    }

    private void submitIntents(Collection<Intent> intents) {
        IntentOperations.Builder builder = IntentOperations.builder((ApplicationId)this.appId());
        for (Intent intent : intents) {
            builder.addSubmitOperation(intent);
        }
        this.service.execute(builder.build());
        this.print("Submitted %d host to host intents.", intents.size());
    }

    private void withdrawIntents() {
        IntentOperations.Builder builder = IntentOperations.builder((ApplicationId)this.appId());
        for (Intent intent : this.service.getIntents()) {
            if (!this.appId().equals(intent.appId())) continue;
            builder.addWithdrawOperation(intent.id());
        }
        this.service.execute(builder.build());
        this.print("Withdrew all randomly generated host to host intents.", new Object[0]);
    }

    @Override
    protected ApplicationId appId() {
        return RandomIntentCommand.get(CoreService.class).registerApplication("org.onosproject.cli-random");
    }
}

