/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.AddPointToPointIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.resource.LinkResourceAllocations;
import org.onosproject.net.resource.LinkResourceService;

@Command(scope="onos", name="resource-allocations", description="Lists allocations by link")
public class ResourceAllocationsCommand
extends AbstractShellCommand {
    private static final String FMT = "src=%s/%s, dst=%s/%s, type=%s%s";
    private static final String COMPACT = "%s/%s-%s/%s";
    @Argument(index=0, name="srcString", description="Link source", required=false, multiValued=false)
    String srcString = null;
    @Argument(index=1, name="dstString", description="Link destination", required=false, multiValued=false)
    String dstString = null;

    @Override
    protected void execute() {
        LinkResourceService resourceService = ResourceAllocationsCommand.get(LinkResourceService.class);
        LinkService linkService = ResourceAllocationsCommand.get(LinkService.class);
        Iterable itr = null;
        try {
            DeviceId ingressDeviceId = DeviceId.deviceId((String)AddPointToPointIntentCommand.getDeviceId(this.srcString));
            PortNumber ingressPortNumber = PortNumber.portNumber((String)AddPointToPointIntentCommand.getPortNumber(this.srcString));
            ConnectPoint src = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
            DeviceId egressDeviceId = DeviceId.deviceId((String)AddPointToPointIntentCommand.getDeviceId(this.dstString));
            PortNumber egressPortNumber = PortNumber.portNumber((String)AddPointToPointIntentCommand.getPortNumber(this.dstString));
            ConnectPoint dst = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
            Link link = linkService.getLink(src, dst);
            itr = resourceService.getAllocations(link);
            for (LinkResourceAllocations allocation : itr) {
                this.print("%s", allocation.getResourceAllocation(link));
            }
        }
        catch (Exception e) {
            this.print("----- Displaying all resource allocations -----", e.getMessage());
            itr = resourceService.getAllocations();
            for (LinkResourceAllocations allocation : itr) {
                this.print("%s", allocation);
            }
        }
    }
}

