/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import java.util.Comparator;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.host.PortAddresses;
import org.onosproject.net.topology.TopologyCluster;

public final class Comparators {
    public static final Comparator<ApplicationId> APP_ID_COMPARATOR = new Comparator<ApplicationId>(){

        @Override
        public int compare(ApplicationId id1, ApplicationId id2) {
            return id1.id() - id2.id();
        }
    };
    public static final Comparator<Application> APP_COMPARATOR = new Comparator<Application>(){

        @Override
        public int compare(Application app1, Application app2) {
            return app1.id().id() - app2.id().id();
        }
    };
    public static final Comparator<ElementId> ELEMENT_ID_COMPARATOR = new Comparator<ElementId>(){

        @Override
        public int compare(ElementId id1, ElementId id2) {
            return id1.toString().compareTo(id2.toString());
        }
    };
    public static final Comparator<Element> ELEMENT_COMPARATOR = new Comparator<Element>(){

        @Override
        public int compare(Element e1, Element e2) {
            return e1.id().toString().compareTo(e2.id().toString());
        }
    };
    public static final Comparator<FlowRule> FLOW_RULE_COMPARATOR = new Comparator<FlowRule>(){

        @Override
        public int compare(FlowRule f1, FlowRule f2) {
            return Long.valueOf(f1.id().value()).compareTo(f2.id().value());
        }
    };
    public static final Comparator<Port> PORT_COMPARATOR = new Comparator<Port>(){

        @Override
        public int compare(Port p1, Port p2) {
            long delta = p1.number().toLong() - p2.number().toLong();
            return delta == 0L ? 0 : (delta < 0L ? -1 : 1);
        }
    };
    public static final Comparator<TopologyCluster> CLUSTER_COMPARATOR = new Comparator<TopologyCluster>(){

        @Override
        public int compare(TopologyCluster c1, TopologyCluster c2) {
            return c1.id().index() - c2.id().index();
        }
    };
    public static final Comparator<ControllerNode> NODE_COMPARATOR = new Comparator<ControllerNode>(){

        @Override
        public int compare(ControllerNode ci1, ControllerNode ci2) {
            return ci1.id().toString().compareTo(ci2.id().toString());
        }
    };
    public static final Comparator<ConnectPoint> CONNECT_POINT_COMPARATOR = new Comparator<ConnectPoint>(){

        @Override
        public int compare(ConnectPoint o1, ConnectPoint o2) {
            int compareId = ELEMENT_ID_COMPARATOR.compare(o1.elementId(), o2.elementId());
            return compareId != 0 ? compareId : Long.signum(o1.port().toLong() - o2.port().toLong());
        }
    };
    public static final Comparator<PortAddresses> ADDRESSES_COMPARATOR = new Comparator<PortAddresses>(){

        @Override
        public int compare(PortAddresses arg0, PortAddresses arg1) {
            return CONNECT_POINT_COMPARATOR.compare(arg0.connectPoint(), arg1.connectPoint());
        }
    };

    private Comparators() {
    }
}

