/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;

@Command(scope="onos", name="nodes", description="Lists all controller cluster nodes")
public class NodesListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, address=%s:%s, state=%s %s";

    @Override
    protected void execute() {
        ClusterService service = NodesListCommand.get(ClusterService.class);
        ArrayList nodes = Lists.newArrayList((Iterable)service.getNodes());
        Collections.sort(nodes, Comparators.NODE_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(service, nodes));
        } else {
            ControllerNode self = service.getLocalNode();
            for (ControllerNode node : nodes) {
                this.print(FMT, node.id(), node.ip(), node.tcpPort(), service.getState(node.id()), node.equals(self) ? "*" : "");
            }
        }
    }

    private JsonNode json(ClusterService service, List<ControllerNode> nodes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        ControllerNode self = service.getLocalNode();
        for (ControllerNode node : nodes) {
            result.add((JsonNode)mapper.createObjectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("tcpPort", node.tcpPort()).put("state", service.getState(node.id()).toString()).put("self", node.equals(self)));
        }
        return result;
    }
}

