/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;

@Command(scope="onos", name="app", description="Manages application inventory")
public class ApplicationCommand
extends AbstractShellCommand {
    static final String INSTALL = "install";
    static final String UNINSTALL = "uninstall";
    static final String ACTIVATE = "activate";
    static final String DEACTIVATE = "deactivate";
    @Argument(index=0, name="command", description="Command name (activate|deactivate|uninstall)", required=true, multiValued=false)
    String command = null;
    @Argument(index=1, name="name", description="Application name", required=true, multiValued=false)
    String name = null;

    @Override
    protected void execute() {
        ApplicationAdminService service = ApplicationCommand.get(ApplicationAdminService.class);
        if (this.command.equals(INSTALL)) {
            this.print("Not supported via CLI yet.", new Object[0]);
        } else {
            ApplicationId appId = service.getId(this.name);
            if (appId == null) {
                this.print("No such application: %s", this.name);
                return;
            }
            if (this.command.equals(UNINSTALL)) {
                service.uninstall(appId);
            } else if (this.command.equals(ACTIVATE)) {
                service.activate(appId);
            } else if (this.command.equals(DEACTIVATE)) {
                service.deactivate(appId);
            }
        }
    }
}

